/*
 * Decompiled with CFR 0.152.
 */
package classFile;

import classFile.GameMode;
import classFile.MainPanel;
import classFile.PcModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PartyModel {
    private GameMode Gm;
    public final byte PARTY_NUM;
    private boolean Light;
    private boolean ViewDarkZone;
    private boolean[] AttackAddPlus;
    private byte[] PartyMember;
    private byte X;
    private byte Y;
    private byte Direction;
    private byte DungeonFloor;
    private byte DungeonNumber;
    private byte[] ResistPlus;
    private int IdentifyCount;
    private int Identify;
    private int Vision;
    private int PoisonPlus;
    private int Protect;
    private int Flying;
    private int HitRate;
    private int HealRate;
    private int HealPlus;
    private int[] AbiPlus;
    private int[] AbiRate;
    private int[] ResistRate;
    private int[] AttackAddRate;
    private int SpellCancelRate;
    private int SpellResist;
    private int BreathResist;
    private int AddDmgPlus;
    private int AddDmgRate;
    private int TmpHp;
    private int TmpHpRate;
    private int AcPlus;
    private int HitPlus;
    private int SpellCancelPlus;
    private int SResistPlus;
    private int BResistPlus;
    private int AtCountPlus;
    private int AtCountRate;
    private int PreemptiveCount;
    private int Preemptive;
    private int EncounterRate;
    private int EncounterPlus;
    private int SecretDoorRate;
    private int SecretDoor;
    private int LockedDoorRate;
    private int LockedDoor;
    private String FlyingEffect;
    private String DungeonMusic;

    PartyModel(GameMode gameMode, int n) {
        this.Gm = gameMode;
        this.PARTY_NUM = (byte)n;
        this.AbiPlus = new int[36];
        this.AbiRate = new int[36];
        this.ResistPlus = new byte[14];
        this.ResistRate = new int[14];
        this.AttackAddPlus = new boolean[6];
        this.AttackAddRate = new int[6];
        this.startup();
    }

    public void startup() {
        this.PartyMember = new byte[this.Gm.PARTY_MEMBER_MAX];
        int n = this.PartyMember.length;
        for (int i = 0; i < 6; ++i) {
            if (i < n) {
                this.PartyMember[i] = -1;
            }
            if (this.PARTY_NUM <= -1) continue;
            this.Gm.Sd.PartyMember[this.PARTY_NUM][i] = -1;
        }
        this.DungeonNumber = (byte)-1;
        this.DungeonFloor = 1;
        this.X = 0;
        this.Y = 0;
        this.Direction = 0;
        this.DungeonMusic = "";
        if (this.PARTY_NUM > -1) {
            this.Gm.Sd.DungeonNumber[this.PARTY_NUM] = -1;
            this.Gm.Sd.DungeonFloor[this.PARTY_NUM] = 1;
            this.Gm.Sd.X[this.PARTY_NUM] = 0;
            this.Gm.Sd.Y[this.PARTY_NUM] = 0;
            this.Gm.Sd.Direction[this.PARTY_NUM] = 0;
            this.Gm.Sd.DungeonMusicP[this.PARTY_NUM] = "";
        }
        this.spellEffectClear(true);
    }

    public void spellEffectClear(boolean bl) {
        int n;
        this.Light = false;
        this.ViewDarkZone = false;
        this.Vision = 0;
        if (this.PARTY_NUM > -1 && this.DungeonNumber > -1 && this.DungeonFloor > -1 && this.Gm.DUNGEON.getValueBoolean("light", this.DungeonFloor)) {
            this.Vision = -1002;
        }
        this.IdentifyCount = 0;
        this.Identify = 0;
        this.Protect = 0;
        this.AcPlus = 0;
        this.Flying = 0;
        this.FlyingEffect = "";
        this.HitRate = 0;
        this.HitPlus = 0;
        this.AddDmgRate = 0;
        this.AddDmgPlus = 0;
        this.HealRate = 0;
        this.HealPlus = 0;
        this.SpellCancelRate = 0;
        this.SpellCancelPlus = 0;
        this.SpellResist = 0;
        this.SResistPlus = 0;
        this.BreathResist = 0;
        this.BResistPlus = 0;
        this.PreemptiveCount = 0;
        this.Preemptive = 0;
        this.SecretDoorRate = 0;
        this.SecretDoor = 0;
        this.LockedDoorRate = 0;
        this.LockedDoor = 0;
        this.EncounterRate = 0;
        this.EncounterPlus = 0;
        this.TmpHp = 0;
        this.TmpHpRate = 0;
        this.AtCountRate = 0;
        this.AtCountPlus = 0;
        this.PoisonPlus = 0;
        if (this.PARTY_NUM > -1) {
            this.Gm.Sd.LightP[this.PARTY_NUM] = this.Light;
            this.Gm.Sd.ViewDarkZone[this.PARTY_NUM] = this.ViewDarkZone;
            this.Gm.Sd.Vision[this.PARTY_NUM] = this.Vision;
            this.Gm.Sd.IdentifyCountP[this.PARTY_NUM] = this.IdentifyCount;
            this.Gm.Sd.IdentifyP[this.PARTY_NUM] = this.Identify;
            this.Gm.Sd.ProtectP[this.PARTY_NUM] = this.Protect;
            this.Gm.Sd.AcPlusP[this.PARTY_NUM] = this.AcPlus;
            this.Gm.Sd.FlyingP[this.PARTY_NUM] = this.Flying;
            this.Gm.Sd.FlyingEffectP[this.PARTY_NUM] = this.FlyingEffect;
            this.Gm.Sd.HitRateP[this.PARTY_NUM] = this.HitRate;
            this.Gm.Sd.HitPlusP[this.PARTY_NUM] = this.HitPlus;
            this.Gm.Sd.AddDmgRateP[this.PARTY_NUM] = this.AddDmgRate;
            this.Gm.Sd.AddDmgPlusP[this.PARTY_NUM] = this.AddDmgPlus;
            this.Gm.Sd.HealRateP[this.PARTY_NUM] = this.HealRate;
            this.Gm.Sd.HealPlusP[this.PARTY_NUM] = this.HealPlus;
            this.Gm.Sd.SpellCancelRateP[this.PARTY_NUM] = this.SpellCancelRate;
            this.Gm.Sd.SpellCancelPlusP[this.PARTY_NUM] = this.SpellCancelPlus;
            this.Gm.Sd.SpellResistP[this.PARTY_NUM] = this.SpellResist;
            this.Gm.Sd.SResistPlusP[this.PARTY_NUM] = this.SResistPlus;
            this.Gm.Sd.BreathResistP[this.PARTY_NUM] = this.BreathResist;
            this.Gm.Sd.BResistPlusP[this.PARTY_NUM] = this.BResistPlus;
            this.Gm.Sd.PreemptiveCountP[this.PARTY_NUM] = this.PreemptiveCount;
            this.Gm.Sd.PreemptiveP[this.PARTY_NUM] = this.Preemptive;
            this.Gm.Sd.SecretDoorRateP[this.PARTY_NUM] = this.SecretDoorRate;
            this.Gm.Sd.SecretDoorP[this.PARTY_NUM] = this.SecretDoor;
            this.Gm.Sd.LockedDoorRateP[this.PARTY_NUM] = this.LockedDoorRate;
            this.Gm.Sd.LockedDoorP[this.PARTY_NUM] = this.LockedDoor;
            this.Gm.Sd.EncounterRateP[this.PARTY_NUM] = this.EncounterRate;
            this.Gm.Sd.EncounterPlusP[this.PARTY_NUM] = this.EncounterPlus;
            this.Gm.Sd.TmpHpP[this.PARTY_NUM] = this.TmpHp;
            this.Gm.Sd.TmpHpRateP[this.PARTY_NUM] = this.TmpHpRate;
            this.Gm.Sd.AtCountRateP[this.PARTY_NUM] = this.AtCountRate;
            this.Gm.Sd.AtCountPlusP[this.PARTY_NUM] = this.AtCountPlus;
            this.Gm.Sd.PoisonPlusP[this.PARTY_NUM] = this.PoisonPlus;
        }
        for (n = 0; n < this.AbiPlus.length; ++n) {
            this.AbiPlus[n] = 0;
            this.AbiRate[n] = 0;
            if (this.PARTY_NUM <= -1) continue;
            this.Gm.Sd.AbiPlusP[this.PARTY_NUM][n] = this.AbiPlus[n];
            this.Gm.Sd.AbiRateP[this.PARTY_NUM][n] = this.AbiRate[n];
        }
        for (n = 0; n < this.ResistPlus.length; ++n) {
            this.ResistPlus[n] = -2;
            this.ResistRate[n] = 0;
            if (this.PARTY_NUM <= -1) continue;
            this.Gm.Sd.ResistPlusP[this.PARTY_NUM][n] = this.ResistPlus[n];
            this.Gm.Sd.ResistRateP[this.PARTY_NUM][n] = this.ResistRate[n];
        }
        for (n = 0; n < this.AttackAddPlus.length; ++n) {
            this.AttackAddPlus[n] = false;
            this.AttackAddRate[n] = 0;
            if (this.PARTY_NUM <= -1) continue;
            this.Gm.Sd.AttackAddPlusP[this.PARTY_NUM][n] = this.AttackAddPlus[n];
            this.Gm.Sd.AttackAddRateP[this.PARTY_NUM][n] = this.AttackAddRate[n];
        }
        if (this.PARTY_NUM > -1) {
            int n2 = this.PartyMember.length;
            boolean bl2 = false;
            for (n = 0; n < n2; ++n) {
                if (this.PartyMember[n] <= -1) continue;
                byte by = this.PartyMember[n];
                this.Gm.PC[by].spellEffectClear(bl);
                bl2 = true;
            }
            if (bl2) {
                this.check();
            }
        }
    }

    public void setValue(String string, int n) {
        if (string.equals("x")) {
            this.X = (byte)n;
            this.Gm.Sd.X[this.PARTY_NUM] = (byte)n;
        } else if (string.equals("y")) {
            this.Y = (byte)n;
            this.Gm.Sd.Y[this.PARTY_NUM] = (byte)n;
        } else if (string.equals("vision")) {
            this.Vision = n;
            this.Gm.Sd.Vision[this.PARTY_NUM] = n;
        } else if (string.equals("direction")) {
            this.Direction = (byte)n;
            this.Gm.Sd.Direction[this.PARTY_NUM] = (byte)n;
        } else if (string.equals("floor")) {
            this.DungeonFloor = (byte)n;
            this.Gm.Sd.DungeonFloor[this.PARTY_NUM] = (byte)n;
        } else if (string.equals("dungeonNumber")) {
            this.DungeonNumber = (byte)n;
            this.Gm.Sd.DungeonNumber[this.PARTY_NUM] = (byte)n;
        } else if (string.equals("identifyCount")) {
            this.IdentifyCount = n;
            this.Gm.Sd.IdentifyCountP[this.PARTY_NUM] = n;
        } else if (string.equals("identify")) {
            this.Identify = n;
            this.Gm.Sd.IdentifyP[this.PARTY_NUM] = n;
        } else if (string.equals("preemptiveCount")) {
            this.PreemptiveCount = n;
            this.Gm.Sd.PreemptiveCountP[this.PARTY_NUM] = n;
        } else if (string.equals("preemptive")) {
            this.Preemptive = n;
            this.Gm.Sd.PreemptiveP[this.PARTY_NUM] = n;
        } else if (string.equals("protect")) {
            this.Protect = n;
            this.Gm.Sd.ProtectP[this.PARTY_NUM] = n;
        } else if (string.equals("acPlus")) {
            this.AcPlus = n;
            this.Gm.Sd.AcPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("flying")) {
            this.Flying = n;
            this.Gm.Sd.FlyingP[this.PARTY_NUM] = n;
        } else if (string.equals("hitRate")) {
            this.HitRate = n;
            this.Gm.Sd.HitRateP[this.PARTY_NUM] = n;
        } else if (string.equals("hitPlus")) {
            this.HitPlus = n;
            this.Gm.Sd.HitPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("addDmgRate")) {
            this.AddDmgRate = n;
            this.Gm.Sd.AddDmgRateP[this.PARTY_NUM] = n;
        } else if (string.equals("addDmgPlus")) {
            this.AddDmgPlus = n;
            this.Gm.Sd.AddDmgPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("healRate")) {
            this.HealRate = n;
            this.Gm.Sd.HealRateP[this.PARTY_NUM] = n;
        } else if (string.equals("healPlus")) {
            this.HealPlus = n;
            this.Gm.Sd.HealPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("spellCancelRate")) {
            this.SpellCancelRate = n;
            this.Gm.Sd.SpellCancelRateP[this.PARTY_NUM] = n;
        } else if (string.equals("spellCancelPlus")) {
            this.SpellCancelPlus = n;
            this.Gm.Sd.SpellCancelPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("spellResist")) {
            this.SpellResist = n;
            this.Gm.Sd.SpellResistP[this.PARTY_NUM] = n;
        } else if (string.equals("sResistPlus")) {
            this.SResistPlus = n;
            this.Gm.Sd.SResistPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("breathResist")) {
            this.BreathResist = n;
            this.Gm.Sd.BreathResistP[this.PARTY_NUM] = n;
        } else if (string.equals("bResistPlus")) {
            this.BResistPlus = n;
            this.Gm.Sd.BResistPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("secretDoorRate")) {
            this.SecretDoorRate = n;
            this.Gm.Sd.SecretDoorRateP[this.PARTY_NUM] = n;
        } else if (string.equals("secretDoor")) {
            this.SecretDoor = n;
            this.Gm.Sd.SecretDoorP[this.PARTY_NUM] = n;
        } else if (string.equals("lockedDoorRate")) {
            this.LockedDoorRate = n;
            this.Gm.Sd.LockedDoorRateP[this.PARTY_NUM] = n;
        } else if (string.equals("lockedDoor")) {
            this.LockedDoor = n;
            this.Gm.Sd.LockedDoorP[this.PARTY_NUM] = n;
        } else if (string.equals("encounterRate")) {
            this.EncounterRate = n;
            this.Gm.Sd.EncounterRateP[this.PARTY_NUM] = n;
        } else if (string.equals("encounterPlus")) {
            this.EncounterPlus = n;
            this.Gm.Sd.EncounterPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("tmpHpRate")) {
            this.TmpHpRate = n;
            this.Gm.Sd.TmpHpRateP[this.PARTY_NUM] = n;
        } else if (string.equals("tmpHp")) {
            this.TmpHp = n;
            this.Gm.Sd.TmpHpP[this.PARTY_NUM] = n;
        } else if (string.equals("atCountPlus")) {
            this.AtCountPlus = n;
            this.Gm.Sd.AtCountPlusP[this.PARTY_NUM] = n;
        } else if (string.equals("atCountRate")) {
            this.AtCountRate = n;
            this.Gm.Sd.AtCountRateP[this.PARTY_NUM] = n;
        } else if (string.equals("poisonPlus")) {
            this.PoisonPlus = n;
            this.Gm.Sd.PoisonPlusP[this.PARTY_NUM] = n;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValue(String string, int n, int n2) {
        if (string.equals("abiPlus")) {
            this.AbiPlus[n] = n2;
            this.Gm.Sd.AbiPlusP[this.PARTY_NUM][n] = n2;
        } else if (string.equals("abiRate")) {
            this.AbiRate[n] = n2;
            this.Gm.Sd.AbiRateP[this.PARTY_NUM][n] = n2;
        } else if (string.equals("resistPlus")) {
            this.ResistPlus[n] = (byte)n2;
            this.Gm.Sd.ResistPlusP[this.PARTY_NUM][n] = (byte)n2;
        } else if (string.equals("resistRate")) {
            this.ResistRate[n] = n2;
            this.Gm.Sd.ResistRateP[this.PARTY_NUM][n] = n2;
        } else if (string.equals("attackAddRate")) {
            this.AttackAddRate[n] = n2;
            this.Gm.Sd.AttackAddRateP[this.PARTY_NUM][n] = n2;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueBoolean(String string, boolean bl) {
        if (string.equals("light")) {
            this.Light = bl;
            this.Gm.Sd.LightP[this.PARTY_NUM] = bl;
        } else if (string.equals("viewDarkZone")) {
            this.ViewDarkZone = bl;
            this.Gm.Sd.ViewDarkZone[this.PARTY_NUM] = bl;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueBoolean(String string, int n, boolean bl) {
        if (string.equals("attackAddPlus")) {
            this.AttackAddPlus[n] = bl;
            this.Gm.Sd.AttackAddPlusP[this.PARTY_NUM][n] = bl;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueStr(String string, String string2) {
        if (string.equals("flyingEffect")) {
            this.FlyingEffect = string2;
            this.Gm.Sd.FlyingEffectP[this.PARTY_NUM] = string2;
        } else if (string.equals("dungeonMusic")) {
            this.DungeonMusic = string2;
            this.Gm.Sd.DungeonMusicP[this.PARTY_NUM] = string2;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueNoSd(String string, int n) {
        if (string.equals("x")) {
            this.X = (byte)n;
        } else if (string.equals("y")) {
            this.Y = (byte)n;
        } else if (string.equals("vision")) {
            this.Vision = n;
        } else if (string.equals("direction")) {
            this.Direction = (byte)n;
        } else if (string.equals("floor")) {
            this.DungeonFloor = (byte)n;
        } else if (string.equals("dungeonNumber")) {
            this.DungeonNumber = (byte)n;
        } else if (string.equals("identifyCount")) {
            this.IdentifyCount = n;
        } else if (string.equals("identify")) {
            this.Identify = n;
        } else if (string.equals("preemptiveCount")) {
            this.PreemptiveCount = n;
        } else if (string.equals("preemptive")) {
            this.Preemptive = n;
        } else if (string.equals("protect")) {
            this.Protect = n;
        } else if (string.equals("acPlus")) {
            this.AcPlus = n;
        } else if (string.equals("flying")) {
            this.Flying = n;
        } else if (string.equals("hitRate")) {
            this.HitRate = n;
        } else if (string.equals("hitPlus")) {
            this.HitPlus = n;
        } else if (string.equals("addDmgRate")) {
            this.AddDmgRate = n;
        } else if (string.equals("addDmgPlus")) {
            this.AddDmgPlus = n;
        } else if (string.equals("healRate")) {
            this.HealRate = n;
        } else if (string.equals("healPlus")) {
            this.HealPlus = n;
        } else if (string.equals("spellCancelRate")) {
            this.SpellCancelRate = n;
        } else if (string.equals("spellCancelPlus")) {
            this.SpellCancelPlus = n;
        } else if (string.equals("spellResist")) {
            this.SpellResist = n;
        } else if (string.equals("sResistPlus")) {
            this.SResistPlus = n;
        } else if (string.equals("breathResist")) {
            this.BreathResist = n;
        } else if (string.equals("bResistPlus")) {
            this.BResistPlus = n;
        } else if (string.equals("secretDoorRate")) {
            this.SecretDoorRate = n;
        } else if (string.equals("secretDoor")) {
            this.SecretDoor = n;
        } else if (string.equals("lockedDoorRate")) {
            this.LockedDoorRate = n;
        } else if (string.equals("lockedDoor")) {
            this.LockedDoor = n;
        } else if (string.equals("encounterRate")) {
            this.EncounterRate = n;
        } else if (string.equals("encounterPlus")) {
            this.EncounterPlus = n;
        } else if (string.equals("tmpHpRate")) {
            this.TmpHpRate = n;
        } else if (string.equals("tmpHp")) {
            this.TmpHp = n;
        } else if (string.equals("atCountPlus")) {
            this.AtCountPlus = n;
        } else if (string.equals("atCountRate")) {
            this.AtCountRate = n;
        } else if (string.equals("poisonPlus")) {
            this.PoisonPlus = n;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueNoSd(String string, int n, int n2) {
        if (string.equals("abiPlus")) {
            this.AbiPlus[n] = n2;
        } else if (string.equals("abiRate")) {
            this.AbiRate[n] = n2;
        } else if (string.equals("resistPlus")) {
            this.ResistPlus[n] = (byte)n2;
        } else if (string.equals("resistRate")) {
            this.ResistRate[n] = n2;
        } else if (string.equals("attackAddRate")) {
            this.AttackAddRate[n] = n2;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueBooleanNoSd(String string, boolean bl) {
        if (string.equals("light")) {
            this.Light = bl;
        } else if (string.equals("viewDarkZone")) {
            this.ViewDarkZone = bl;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueBooleanNoSd(String string, int n, boolean bl) {
        if (string.equals("attackAddPlus")) {
            this.AttackAddPlus[n] = bl;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public void setValueStrNoSd(String string, String string2) {
        if (string.equals("flyingEffect")) {
            this.FlyingEffect = string2;
        } else if (string.equals("dungeonMusic")) {
            this.DungeonMusic = string2;
        } else {
            this.Gm.debugPrintln("No setting");
        }
    }

    public int getValue(String string) {
        if (string.equals("x")) {
            return this.X;
        }
        if (string.equals("y")) {
            return this.Y;
        }
        if (string.equals("vision")) {
            return this.Vision;
        }
        if (string.equals("direction")) {
            return this.Direction;
        }
        if (string.equals("floor")) {
            return this.DungeonFloor;
        }
        if (string.equals("dungeonNumber")) {
            return this.DungeonNumber;
        }
        if (string.equals("identifyCount")) {
            return this.IdentifyCount;
        }
        if (string.equals("identify")) {
            return this.Identify;
        }
        if (string.equals("preemptiveCount")) {
            return this.PreemptiveCount;
        }
        if (string.equals("preemptive")) {
            return this.Preemptive;
        }
        if (string.equals("protect")) {
            return this.Protect;
        }
        if (string.equals("acPlus")) {
            return this.AcPlus;
        }
        if (string.equals("flying")) {
            return this.Flying;
        }
        if (string.equals("hitRate")) {
            return this.HitRate;
        }
        if (string.equals("hitPlus")) {
            return this.HitPlus;
        }
        if (string.equals("addDmgRate")) {
            return this.AddDmgRate;
        }
        if (string.equals("addDmgPlus")) {
            return this.AddDmgPlus;
        }
        if (string.equals("healRate")) {
            return this.HealRate;
        }
        if (string.equals("healPlus")) {
            return this.HealPlus;
        }
        if (string.equals("spellCancelRate")) {
            return this.SpellCancelRate;
        }
        if (string.equals("spellCancelPlus")) {
            return this.SpellCancelPlus;
        }
        if (string.equals("spellResist")) {
            return this.SpellResist;
        }
        if (string.equals("sResistPlus")) {
            return this.SResistPlus;
        }
        if (string.equals("breathResist")) {
            return this.BreathResist;
        }
        if (string.equals("bResistPlus")) {
            return this.BResistPlus;
        }
        if (string.equals("secretDoorRate")) {
            return this.SecretDoorRate;
        }
        if (string.equals("secretDoor")) {
            return this.SecretDoor;
        }
        if (string.equals("lockedDoorRate")) {
            return this.LockedDoorRate;
        }
        if (string.equals("lockedDoor")) {
            return this.LockedDoor;
        }
        if (string.equals("encounterRate")) {
            return this.EncounterRate;
        }
        if (string.equals("encounterPlus")) {
            return this.EncounterPlus;
        }
        if (string.equals("tmpHp")) {
            return this.TmpHp;
        }
        if (string.equals("tmpHpRate")) {
            return this.TmpHpRate;
        }
        if (string.equals("atCountPlus")) {
            return this.AtCountPlus;
        }
        if (string.equals("atCountRate")) {
            return this.AtCountRate;
        }
        if (string.equals("poisonPlus")) {
            return this.PoisonPlus;
        }
        return 0;
    }

    public int getValue(String string, int n) {
        if (string.equals("abiPlus")) {
            return this.AbiPlus[n];
        }
        if (string.equals("abiRate")) {
            return this.AbiRate[n];
        }
        if (string.equals("resistPlus")) {
            return this.ResistPlus[n];
        }
        if (string.equals("resistRate")) {
            return this.ResistRate[n];
        }
        if (string.equals("attackAddRate")) {
            return this.AttackAddRate[n];
        }
        return 0;
    }

    public boolean getValueBoolean(String string) {
        if (string.equals("light")) {
            return this.Light;
        }
        if (string.equals("viewDarkZone")) {
            return this.ViewDarkZone;
        }
        return false;
    }

    public boolean getValueBoolean(String string, int n) {
        if (string.equals("attackAddPlus")) {
            return this.AttackAddPlus[n];
        }
        return false;
    }

    public String getValueStr(String string) {
        if (string.equals("flyingEffect")) {
            return this.FlyingEffect;
        }
        if (string.equals("dungeonMusic")) {
            return this.DungeonMusic;
        }
        return "";
    }

    public int getResist(int n, int n2) {
        int n3 = 0;
        int n4 = this.getMemberNum();
        for (int i = 0; i < n4; ++i) {
            if (this.Gm.PC[this.PartyMember[i]].getValue("state") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("asleep") != 0 || n >= this.Gm.PC[this.PartyMember[i]].getLength("resist")) continue;
            if (n2 == 1) {
                if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("resist1", n)) continue;
                n3 = 1;
                break;
            }
            if (n2 == 0) {
                if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("resist0", n)) continue;
                n3 = 1;
                break;
            }
            if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("resist", n)) continue;
            n3 = 1;
            break;
        }
        return n3;
    }

    public int getResist2(int n, int n2) {
        int n3 = 0;
        int n4 = this.getMemberNum();
        for (int i = 0; i < n4; ++i) {
            if (n >= this.Gm.PC[this.PartyMember[i]].getLength("resist")) continue;
            if (n2 == 1) {
                if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("resist1", n)) continue;
                n3 = 1;
                break;
            }
            if (n2 == 0) {
                if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("resist0", n)) continue;
                n3 = 1;
                break;
            }
            if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("resist", n)) continue;
            n3 = 1;
            break;
        }
        return n3;
    }

    public int spellMaster(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getMemberNum();
        for (int i = 0; i < n5; ++i) {
            if (this.Gm.PC[this.PartyMember[i]].getValue("state") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("asleep") != 0 || !this.Gm.PC[this.PartyMember[i]].spellMaster(n, n2, n3)) continue;
            n4 = 1;
            break;
        }
        return n4;
    }

    public int spellMaster2(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getMemberNum();
        for (int i = 0; i < n5; ++i) {
            if (!this.Gm.PC[this.PartyMember[i]].spellMaster(n, n2, n3)) continue;
            n4 = 1;
            break;
        }
        return n4;
    }

    public void addMember(int n) {
        int n2 = this.PartyMember.length;
        for (int i = 0; i < n2; ++i) {
            if (this.PartyMember[i] != -1) continue;
            this.PartyMember[i] = (byte)n;
            this.Gm.Sd.PartyMember[this.PARTY_NUM][i] = (byte)n;
            this.Gm.PC[n].setValue("party", this.PARTY_NUM);
            break;
        }
    }

    public void deleteMember(int n) {
        int n2 = this.PartyMember.length;
        for (int i = 0; i < n2; ++i) {
            if (this.PartyMember[i] != n) continue;
            this.PartyMember[i] = -1;
            this.Gm.Sd.PartyMember[this.PARTY_NUM][i] = -1;
            this.Gm.PC[n].setValue("party", -1);
            int n3 = this.PartyMember.length - 1;
            for (int j = i; j < n3; ++j) {
                this.PartyMember[j] = this.PartyMember[j + 1];
                this.Gm.Sd.PartyMember[this.PARTY_NUM][j] = this.PartyMember[j];
            }
            this.PartyMember[this.PartyMember.length - 1] = -1;
            this.Gm.Sd.PartyMember[this.PARTY_NUM][this.PartyMember.length - 1] = -1;
            break;
        }
        if (this.PartyMember[0] < 0) {
            this.DungeonNumber = (byte)-1;
            this.Gm.Sd.DungeonNumber[this.PARTY_NUM] = -1;
            this.DungeonMusic = "";
            this.Gm.Sd.DungeonMusicP[this.PARTY_NUM] = "";
            this.spellEffectClear(true);
        }
    }

    public void setMember(int n, int n2) {
        if (n >= this.PartyMember.length) {
            n = this.PartyMember.length - 1;
        }
        this.PartyMember[n] = (byte)n2;
        this.Gm.Sd.PartyMember[this.PARTY_NUM][n] = (byte)n2;
    }

    public void setMemberNoSd(int n, int n2) {
        this.PartyMember[n] = (byte)n2;
    }

    public int getMember(int n) {
        if (n >= this.PartyMember.length) {
            n = this.PartyMember.length - 1;
        }
        return this.PartyMember[n];
    }

    public int getMemberForPc(int n) {
        int n2 = -1;
        int n3 = this.PartyMember.length;
        for (int i = 0; i < n3; ++i) {
            if (this.PartyMember[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public int getMemberNum() {
        int n = 0;
        int n2 = this.PartyMember.length;
        for (int i = 0; i < n2 && this.PartyMember[i] > -1; ++i) {
            ++n;
        }
        return n;
    }

    public void dissolution() {
        while (this.checkParty()) {
            this.deleteMember(this.getMember(0));
        }
        this.DungeonNumber = (byte)-1;
        this.Gm.Sd.DungeonNumber[this.PARTY_NUM] = -1;
        this.DungeonMusic = "";
        this.Gm.Sd.DungeonMusicP[this.PARTY_NUM] = "";
        this.spellEffectClear(false);
        this.Gm.setActiveParty(-1);
    }

    public void deleteLostPc() {
        for (int i = 0; i < this.PartyMember.length && this.PartyMember[i] >= 0; ++i) {
            byte by = this.PartyMember[i];
            if (this.Gm.PC[by].getValue("state") != 6) continue;
            this.deleteMember(by);
            this.Gm.pcDelete(by);
            --i;
        }
    }

    public int getMemberAttackAdd(int n, boolean bl) {
        int n2 = 0;
        int n3 = this.PartyMember.length;
        for (int i = 0; i < n3 && this.PartyMember[i] >= 0; ++i) {
            if (bl && !this.Gm.PC[this.PartyMember[i]].possibleToAction() || !this.Gm.PC[this.PartyMember[i]].checkAttackAdd(n)) continue;
            ++n2;
        }
        return n2;
    }

    public int getMemberState(int n) {
        int n2 = 0;
        int n3 = this.PartyMember.length;
        for (int i = 0; i < n3 && this.PartyMember[i] >= 0; ++i) {
            if (n == 0) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("state") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("silence") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("asleep") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("noBreath") != 0 || this.Gm.PC[this.PartyMember[i]].getValueBoolean("sealSpell") || this.Gm.PC[this.PartyMember[i]].getValue("poison") != 0) continue;
                ++n2;
                continue;
            }
            if (n < 7) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("state") != n) continue;
                ++n2;
                continue;
            }
            if (n == 7) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("silence") == 0) continue;
                ++n2;
                continue;
            }
            if (n == 8) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("asleep") <= 0) continue;
                ++n2;
                continue;
            }
            if (n == 9) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("asleep") >= 0) continue;
                ++n2;
                continue;
            }
            if (n == 10) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("noBreath") <= 0) continue;
                ++n2;
                continue;
            }
            if (n == 11) {
                if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("sealSpell")) continue;
                ++n2;
                continue;
            }
            if (n == 12) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("poison") <= 0) continue;
                ++n2;
                continue;
            }
            if (n == 13) {
                if (!this.Gm.BATTLE.getValueBoolean("battleMode") || !this.Gm.PC[this.PartyMember[i]].getValueBoolean("hide")) continue;
                ++n2;
                continue;
            }
            if (n != 14 || !this.Gm.BATTLE.getValueBoolean("battleMode") || this.Gm.PC[this.PartyMember[i]].getValue("action", 0) != 4) continue;
            ++n2;
        }
        return n2;
    }

    public int getPossibleToActionMemberState(int n) {
        int n2 = 0;
        int n3 = this.PartyMember.length;
        for (int i = 0; i < n3 && this.PartyMember[i] >= 0; ++i) {
            if (!this.Gm.PC[this.PartyMember[i]].possibleToAction()) continue;
            if (n == 0) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("state") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("silence") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("asleep") != 0 || this.Gm.PC[this.PartyMember[i]].getValue("noBreath") != 0 || this.Gm.PC[this.PartyMember[i]].getValueBoolean("sealSpell") || this.Gm.PC[this.PartyMember[i]].getValue("poison") != 0) continue;
                ++n2;
                continue;
            }
            if (n < 7) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("state") != n) continue;
                ++n2;
                continue;
            }
            if (n == 7) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("silence") == 0) continue;
                ++n2;
                continue;
            }
            if (n == 8) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("asleep") <= 0) continue;
                ++n2;
                continue;
            }
            if (n == 9) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("asleep") >= 0) continue;
                ++n2;
                continue;
            }
            if (n == 10) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("noBreath") <= 0) continue;
                ++n2;
                continue;
            }
            if (n == 11) {
                if (!this.Gm.PC[this.PartyMember[i]].getValueBoolean("sealSpell")) continue;
                ++n2;
                continue;
            }
            if (n == 12) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("poison") <= 0) continue;
                ++n2;
                continue;
            }
            if (n == 13) {
                if (!this.Gm.BATTLE.getValueBoolean("battleMode") || !this.Gm.PC[this.PartyMember[i]].getValueBoolean("hide")) continue;
                ++n2;
                continue;
            }
            if (n != 14 || !this.Gm.BATTLE.getValueBoolean("battleMode") || this.Gm.PC[this.PartyMember[i]].getValue("action", 0) != 4) continue;
            ++n2;
        }
        return n2;
    }

    public boolean frontRankCheck(int n) {
        return n < this.Gm.FRONT_RANK_NUM;
    }

    public int getItemSpaceNum() {
        int n = 0;
        int n2 = this.getMemberNum();
        for (int i = 0; i < n2; ++i) {
            n += this.Gm.PC[this.PartyMember[i]].getItemSpaceNum();
        }
        return n;
    }

    public int haveItemNum(int n, int n2) {
        int n3 = this.getMemberNum();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = this.Gm.PC[this.PartyMember[i]].haveItemNum(n, n2);
            n4 += n5;
        }
        return n4;
    }

    public int itemCommentNum(String string, int n) {
        int n2 = this.getMemberNum();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.Gm.PC[this.PartyMember[i]].itemCommentNum(string, n);
            n3 += n4;
        }
        return n3;
    }

    public int raceCommentNum(String string) {
        int n = this.getMemberNum();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.Gm.PC[this.PartyMember[i]].raceCommentNum(string);
            n2 += n3;
        }
        return n2;
    }

    public int classCommentNum(String string) {
        int n = this.getMemberNum();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.Gm.PC[this.PartyMember[i]].classCommentNum(string);
            n2 += n3;
        }
        return n2;
    }

    public int putItem(int n, int n2) {
        int n3 = -1;
        int n4 = this.getMemberNum();
        if (this.Gm.ITEM_IS_GOT_IN_TURN) {
            for (int i = 0; i < n4; ++i) {
                if (!this.Gm.PC[this.PartyMember[i]].putItem(n, n2)) continue;
                n3 = i;
                break;
            }
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < n4; ++i) {
                if (this.Gm.PC[this.PartyMember[i]].getItemSpaceNum() <= 0) continue;
                arrayList.add(i);
            }
            if (arrayList.size() > 0) {
                n3 = (Integer)arrayList.get(this.Gm.dice(1, arrayList.size()) - 1);
                this.Gm.PC[this.PartyMember[n3]].putItem(n, n2);
            }
        }
        return n3;
    }

    public boolean deleteItem(int n, int n2) {
        boolean bl = false;
        int n3 = this.getMemberNum();
        for (int i = 0; i < n3; ++i) {
            if (!this.Gm.PC[this.PartyMember[i]].deleteItem2(n, n2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int[] deleteItemReturnPC(int n, int n2) {
        int[] nArray = new int[]{-1, -1};
        int n3 = this.getMemberNum();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.Gm.PC[this.PartyMember[i]].deleteItem2(n, n2, -1);
            if (n4 <= -1) continue;
            nArray[0] = this.PartyMember[i];
            nArray[1] = n4;
            break;
        }
        return nArray;
    }

    public int[] deleteItemExceptSpecifiedPC(int n, int n2, int n3) {
        int[] nArray = new int[]{-1, -1};
        int n4 = this.getMemberNum();
        for (int i = 0; i < n4; ++i) {
            int n5;
            if (this.PartyMember[i] == n3 || (n5 = this.Gm.PC[this.PartyMember[i]].deleteItem2(n, n2, -1)) <= -1) continue;
            nArray[0] = this.PartyMember[i];
            nArray[1] = n5;
            break;
        }
        return nArray;
    }

    public boolean checkTitle(String string) {
        boolean bl = false;
        int n = this.getMemberNum();
        for (int i = 0; i < n; ++i) {
            if (!this.Gm.PC[this.PartyMember[i]].getValueStr("title").equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean checkTitle2(String string) {
        boolean bl = false;
        int n = this.getMemberNum();
        for (int i = 0; i < n; ++i) {
            if (this.Gm.PC[this.PartyMember[i]].getValueStr("title").indexOf(string) <= -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String statusGet() {
        StringBuffer stringBuffer = this.PartyMember[0] > -1 ? new StringBuffer(this.Gm.PC[this.PartyMember[0]].statusListStr()) : new StringBuffer("  ");
        for (int i = 1; i < 6; ++i) {
            if (i > this.PartyMember.length - 1) {
                stringBuffer.append("<br>  ");
                continue;
            }
            if (this.PartyMember[i] > -1) {
                stringBuffer.append("<br>");
                stringBuffer.append(this.Gm.PC[this.PartyMember[i]].statusListStr());
                continue;
            }
            stringBuffer.append("<br>  ");
        }
        return stringBuffer.toString();
    }

    public void statusSet() {
        MainPanel mainPanel = this.Gm.FRAME.MP;
        StringBuffer stringBuffer = this.PartyMember[0] > -1 ? new StringBuffer(this.Gm.PC[this.PartyMember[0]].statusListStr()) : new StringBuffer("  ");
        for (int i = 1; i < 6; ++i) {
            if (i > this.PartyMember.length - 1) {
                stringBuffer.append("<br>  ");
                continue;
            }
            if (this.PartyMember[i] > -1) {
                stringBuffer.append("<br>");
                stringBuffer.append(this.Gm.PC[this.PartyMember[i]].statusListStr());
                continue;
            }
            stringBuffer.append("<br>  ");
        }
        mainPanel.set("partyStatus", stringBuffer.toString());
    }

    public boolean checkParty() {
        return this.PartyMember[0] > -1;
    }

    public int checkAlignment() {
        int n = 1;
        int n2 = this.PartyMember.length;
        for (int i = 0; i < n2 && this.PartyMember[i] != -1; ++i) {
            int n3 = this.Gm.PC[this.PartyMember[i]].getValue("alignment");
            if (n3 == 0) {
                if (n == 1) {
                    n = 0;
                    continue;
                }
                if (n != 2) continue;
                n = 3;
                continue;
            }
            if (n3 != 2) continue;
            if (n == 0) {
                n = 3;
                continue;
            }
            if (n != 1) continue;
            n = 2;
        }
        return n;
    }

    public void healingEffect(boolean bl) {
        MainPanel mainPanel = this.Gm.FRAME.MP;
        int n = this.PartyMember.length;
        for (int i = 0; i < n && this.PartyMember[i] != -1; ++i) {
            int n2;
            String string;
            int n3;
            PcModel pcModel = this.Gm.PC[this.PartyMember[i]];
            if (!bl) {
                pcModel.hpPlus(pcModel.getValue("hpPlus"));
            }
            if (pcModel.getValue("state") == 1 && (n3 = this.Gm.pcCalculation(this.Gm.CURE_AFRAID_PROB, this.PartyMember[i])) >= this.Gm.dice(1, 100)) {
                pcModel.setValue("state", 0);
            }
            if ((n3 = pcModel.getValue("asleep")) > 0) {
                string = this.Gm.replaceStr(this.Gm.CURE_ASLEEP_TURN, "my\\.", "pc.");
                n2 = this.Gm.pcCalculation(string, this.PartyMember[i]);
                if (n2 < 1) {
                    n2 = 1;
                }
                if ((n3 -= n2) < 0) {
                    n3 = 0;
                }
                pcModel.setValue("asleep", n3);
            }
            string = this.Gm.replaceStr(this.Gm.CURE_SILENCE, "my\\.", "pc.");
            n2 = this.Gm.pcCalculation(string, this.PartyMember[i]);
            n3 = pcModel.getValue("silence");
            if (n3 > 0) {
                if ((n3 -= n2) < 0) {
                    n3 = 0;
                }
                pcModel.setValue("silence", n3);
            }
            if ((n3 = pcModel.getValue("noBreath")) <= 0) continue;
            if ((n3 -= n2) < 0) {
                n3 = 0;
            }
            pcModel.setValue("noBreath", n3);
        }
        if (!mainPanel.getValueStr("partyStatus").equals("")) {
            this.statusSet();
        }
    }

    public boolean annihilateCheck() {
        int n = this.PartyMember.length;
        boolean bl = true;
        for (int i = 0; i < n && this.PartyMember[i] != -1; ++i) {
            PcModel pcModel = this.Gm.PC[this.PartyMember[i]];
            if (pcModel.getValue("state") >= 2) continue;
            bl = false;
        }
        return bl;
    }

    public void check() {
        MainPanel mainPanel = this.Gm.FRAME.MP;
        int n = this.getMemberNum();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.Gm.PC[this.PartyMember[i]].check();
            }
        }
        if (!mainPanel.getValueStr("partyStatus").equals("") && this.Gm.getActiveParty() == this.PARTY_NUM && !this.Gm.TOWN.CASTLE_EVENT) {
            this.statusSet();
            mainPanel.paintRepaint();
        }
    }

    public void check2() {
        MainPanel mainPanel = this.Gm.FRAME.MP;
        int n = this.getMemberNum();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.Gm.PC[this.PartyMember[i]].check();
            }
        }
    }

    public void spellEffectEndCheck(int n) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList.add("preemptiveCount");
        arrayList.add("protect");
        arrayList.add("hitRate");
        arrayList.add("healRate");
        arrayList.add("spellCancelRate");
        arrayList.add("spellResist");
        arrayList.add("breathResist");
        arrayList.add("identifyCount");
        arrayList.add("secretDoorRate");
        arrayList.add("lockedDoorRate");
        arrayList.add("encounterRate");
        arrayList.add("addDmgRate");
        arrayList.add("tmpHpRate");
        arrayList.add("atCountRate");
        arrayList2.add("preemptive");
        arrayList2.add("acPlus");
        arrayList2.add("hitPlus");
        arrayList2.add("healPlus");
        arrayList2.add("spellCancelPlus");
        arrayList2.add("sResistPlus");
        arrayList2.add("bResistPlus");
        arrayList2.add("identify");
        arrayList2.add("secretDoor");
        arrayList2.add("lockedDoor");
        arrayList2.add("encounterPlus");
        arrayList2.add("addDmgPlus");
        arrayList2.add("tmpHp");
        arrayList2.add("atCountPlus");
        arrayList3.add("protect");
        arrayList3.add("hitRate");
        arrayList3.add("spellCancelRate");
        arrayList3.add("spellResist");
        arrayList3.add("breathResist");
        arrayList3.add("healRate");
        arrayList3.add("addDmgRate");
        arrayList3.add("tmpHpRate");
        arrayList3.add("atCountRate");
        arrayList4.add("acPlus");
        arrayList4.add("hitPlus");
        arrayList4.add("spellCancelPlus");
        arrayList4.add("sResistPlus");
        arrayList4.add("bResistPlus");
        arrayList4.add("healPlus");
        arrayList4.add("addDmgPlus");
        arrayList4.add("tmpHp");
        arrayList4.add("atCountPlus");
        if (n == 0) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = arrayList.size();
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = this.getValue((String)arrayList.get(n5));
                if (n4 > 0 && n4 <= 1000) {
                    this.setValue((String)arrayList.get(n5), --n4);
                    if (n4 != 0) continue;
                    this.setValue((String)arrayList2.get(n5), 0);
                    bl = true;
                    continue;
                }
                if (n4 >= 0 || n4 < -1000) continue;
                this.setValue((String)arrayList.get(n5), ++n4);
                if (n4 != 0) continue;
                this.setValue((String)arrayList2.get(n5), 0);
                bl = true;
            }
            for (n3 = 0; n3 < this.AbiRate.length; ++n3) {
                n2 = this.getValue("abiRate", n3);
                if (n2 > 0 && n2 <= 1000) {
                    this.setValue("abiRate", n3, --n2);
                    if (n2 != 0) continue;
                    this.setValue("abiPlus", n3, 0);
                    bl = true;
                    continue;
                }
                if (n2 >= 0 || n2 < -1000) continue;
                this.setValue("abiRate", n3, ++n2);
                if (n2 != 0) continue;
                this.setValue("abiPlus", n3, 0);
                bl = true;
            }
            for (n3 = 0; n3 < this.ResistPlus.length; ++n3) {
                n2 = this.getValue("resistRate", n3);
                if (n2 > 0 && n2 <= 1000) {
                    this.setValue("resistRate", n3, --n2);
                    if (n2 != 0) continue;
                    this.setValue("resistPlus", n3, -2);
                    bl = true;
                    continue;
                }
                if (n2 >= 0 || n2 < -1000) continue;
                this.setValue("resistRate", n3, ++n2);
                if (n2 != 0) continue;
                this.setValue("resistPlus", n3, -2);
                bl = true;
            }
            for (n3 = 0; n3 < this.AttackAddPlus.length; ++n3) {
                n2 = this.getValue("attackAddRate", n3);
                if (n2 > 0 && n2 <= 1000) {
                    this.setValue("attackAddRate", n3, --n2);
                    if (n2 != 0) continue;
                    this.setValueBoolean("attackAddPlus", n3, false);
                    bl = true;
                    continue;
                }
                if (n2 >= 0 || n2 < -1000) continue;
                this.setValue("attackAddRate", n3, ++n2);
                if (n2 != 0) continue;
                this.setValueBoolean("attackAddPlus", n3, false);
                bl = true;
            }
            n2 = this.getValue("flying");
            if (n2 > 0 && n2 <= 1000) {
                this.setValue("flying", --n2);
                if (n2 == 0) {
                    this.setValueStr("flyingEffect", "");
                }
            } else if (n2 < 0 && n2 >= -1000) {
                this.setValue("flying", ++n2);
                if (n2 == 0) {
                    this.setValueStr("flyingEffect", "");
                }
            }
            n6 = this.PartyMember.length;
            for (n5 = 0; n5 < n6; ++n5) {
                if (this.PartyMember[n5] <= -1) continue;
                n4 = this.PartyMember[n5];
                int n7 = arrayList3.size();
                for (n3 = 0; n3 < n7; ++n3) {
                    n2 = this.Gm.PC[n4].getValue((String)arrayList3.get(n3));
                    if (n2 > 0 && n2 <= 1000) {
                        this.Gm.PC[n4].setValue((String)arrayList3.get(n3), --n2);
                        if (n2 != 0) continue;
                        this.Gm.PC[n4].setValue((String)arrayList4.get(n3), 0);
                        bl = true;
                        continue;
                    }
                    if (n2 >= 0 || n2 < -1000) continue;
                    this.Gm.PC[n4].setValue((String)arrayList3.get(n3), ++n2);
                    if (n2 != 0) continue;
                    this.Gm.PC[n4].setValue((String)arrayList4.get(n3), 0);
                    bl = true;
                }
                for (n3 = 0; n3 < this.AbiRate.length; ++n3) {
                    n2 = this.Gm.PC[n4].getValue("abiRate", n3);
                    if (n2 > 0 && n2 <= 1000) {
                        this.Gm.PC[n4].setValue("abiRate", n3, --n2);
                        if (n2 != 0) continue;
                        this.Gm.PC[n4].setValue("abiPlus", n3, 0);
                        bl = true;
                        continue;
                    }
                    if (n2 >= 0 || n2 < -1000) continue;
                    this.Gm.PC[n4].setValue("abiRate", n3, ++n2);
                    if (n2 != 0) continue;
                    this.Gm.PC[n4].setValue("abiPlus", n3, 0);
                    bl = true;
                }
                for (n3 = 0; n3 < this.ResistPlus.length; ++n3) {
                    n2 = this.Gm.PC[n4].getValue("resistRate", n3);
                    if (n2 > 0 && n2 <= 1000) {
                        this.Gm.PC[n4].setValue("resistRate", n3, --n2);
                        if (n2 != 0) continue;
                        this.Gm.PC[n4].setValue("resistPlus", n3, -2);
                        bl = true;
                        continue;
                    }
                    if (n2 >= 0 || n2 < -1000) continue;
                    this.Gm.PC[n4].setValue("resistRate", n3, ++n2);
                    if (n2 != 0) continue;
                    this.Gm.PC[n4].setValue("resistPlus", n3, -2);
                    bl = true;
                }
                for (n3 = 0; n3 < this.AttackAddPlus.length; ++n3) {
                    n2 = this.Gm.PC[n4].getValue("attackAddRate", n3);
                    if (n2 > 0 && n2 <= 1000) {
                        this.Gm.PC[n4].setValue("attackAddRate", n3, --n2);
                        if (n2 != 0) continue;
                        this.Gm.PC[n4].setValueBoolean("attackAddPlus", n3, false);
                        bl = true;
                        continue;
                    }
                    if (n2 >= 0 || n2 < -1000) continue;
                    this.Gm.PC[n4].setValue("attackAddRate", n3, ++n2);
                    if (n2 != 0) continue;
                    this.Gm.PC[n4].setValueBoolean("attackAddPlus", n3, false);
                    bl = true;
                }
                n2 = this.Gm.PC[n4].getValue("sealSpellInt");
                if (n2 > 0 && n2 <= 1000) {
                    this.Gm.PC[n4].setValue("sealSpellInt", --n2);
                    if (n2 != 0) continue;
                    this.Gm.PC[n4].setValueBoolean("sealSpell", false);
                    continue;
                }
                if (n2 >= 0 || n2 < -1000) continue;
                this.Gm.PC[n4].setValue("sealSpellInt", ++n2);
                if (n2 != 0) continue;
                this.Gm.PC[n4].setValueBoolean("sealSpell", false);
            }
        } else if (n == 1) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = arrayList.size();
            for (n11 = 0; n11 < n12; ++n11) {
                n10 = this.getValue((String)arrayList.get(n11));
                if (n10 != 1001 && n10 != -1001) continue;
                this.setValue((String)arrayList.get(n11), 0);
                this.setValue((String)arrayList2.get(n11), 0);
                bl = true;
            }
            for (n9 = 0; n9 < this.AbiRate.length; ++n9) {
                n8 = this.getValue("abiRate", n9);
                if (n8 != 1001 && n8 != -1001) continue;
                this.setValue("abiRate", n9, 0);
                this.setValue("abiPlus", n9, 0);
                bl = true;
            }
            for (n9 = 0; n9 < this.ResistPlus.length; ++n9) {
                n8 = this.getValue("resistRate", n9);
                if (n8 != 1001 && n8 != -1001) continue;
                this.setValue("resistRate", n9, 0);
                this.setValue("resistPlus", n9, -2);
                bl = true;
            }
            for (n9 = 0; n9 < this.AttackAddPlus.length; ++n9) {
                n8 = this.getValue("attackAddRate", n9);
                if (n8 != 1001 && n8 != -1001) continue;
                this.setValue("attackAddRate", n9, 0);
                this.setValueBoolean("attackAddPlus", n9, false);
                bl = true;
            }
            n8 = this.getValue("flying");
            if (n8 == 1001 || n8 == -1001) {
                this.setValue("flying", 0);
                this.setValueStr("flyingEffect", "");
            }
            n12 = this.PartyMember.length;
            for (n11 = 0; n11 < n12; ++n11) {
                if (this.PartyMember[n11] <= -1) continue;
                n10 = this.PartyMember[n11];
                int n13 = arrayList3.size();
                for (n9 = 0; n9 < n13; ++n9) {
                    n8 = this.Gm.PC[n10].getValue((String)arrayList3.get(n9));
                    if (n8 != 1001 && n8 != -1001) continue;
                    this.Gm.PC[n10].setValue((String)arrayList3.get(n9), 0);
                    this.Gm.PC[n10].setValue((String)arrayList4.get(n9), 0);
                    bl = true;
                }
                for (n9 = 0; n9 < this.AbiRate.length; ++n9) {
                    n8 = this.Gm.PC[n10].getValue("abiRate", n9);
                    if (n8 != 1001 && n8 != -1001) continue;
                    this.Gm.PC[n10].setValue("abiRate", n9, 0);
                    this.Gm.PC[n10].setValue("abiPlus", n9, 0);
                    bl = true;
                }
                n8 = this.Gm.PC[n10].getValue("sealSpellInt");
                if (n8 != 1001 && n8 != -1001) continue;
                this.Gm.PC[n10].setValue("sealSpellInt", 0);
                this.Gm.PC[n10].setValueBoolean("sealSpell", false);
                bl = true;
            }
        } else if (n == 2) {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18 = arrayList.size();
            for (n17 = 0; n17 < n18; ++n17) {
                n16 = this.getValue((String)arrayList.get(n17));
                if (n16 <= 0) continue;
                this.setValue((String)arrayList.get(n17), 0);
                this.setValue((String)arrayList2.get(n17), 0);
                bl = true;
            }
            for (n15 = 0; n15 < this.AbiRate.length; ++n15) {
                n14 = this.getValue("abiRate", n15);
                if (n14 <= 0) continue;
                this.setValue("abiRate", n15, 0);
                this.setValue("abiPlus", n15, 0);
                bl = true;
            }
            n14 = this.getValue("flying");
            if (n14 > 0) {
                this.setValue("flying", 0);
                this.setValueStr("flyingEffect", "");
            }
            n18 = this.PartyMember.length;
            for (n17 = 0; n17 < n18; ++n17) {
                if (this.PartyMember[n17] <= -1) continue;
                n16 = this.PartyMember[n17];
                int n19 = arrayList3.size();
                for (n15 = 0; n15 < n19; ++n15) {
                    n14 = this.Gm.PC[n16].getValue((String)arrayList3.get(n15));
                    if (n14 <= 0) continue;
                    this.Gm.PC[n16].setValue((String)arrayList3.get(n15), 0);
                    this.Gm.PC[n16].setValue((String)arrayList4.get(n15), 0);
                    bl = true;
                }
                for (n15 = 0; n15 < this.AbiRate.length; ++n15) {
                    n14 = this.Gm.PC[n16].getValue("abiRate", n15);
                    if (n14 <= 0) continue;
                    this.Gm.PC[n16].setValue("abiRate", n15, 0);
                    this.Gm.PC[n16].setValue("abiPlus", n15, 0);
                    bl = true;
                }
                n14 = this.Gm.PC[n16].getValue("sealSpellInt");
                if (n14 <= 0) continue;
                this.Gm.PC[n16].setValue("sealSpellInt", 0);
                this.Gm.PC[n16].setValueBoolean("sealSpell", false);
                bl = true;
            }
        }
        if (bl) {
            this.check();
        }
    }

    public String spellEffectStr() {
        String string;
        MainPanel mainPanel = this.Gm.FRAME.MP;
        int n = 0;
        String[] stringArray = new String[]{"ASLEEP", "PARALYZED", "STONED", "KNOCK_OUT", "CRITICAL", "POISONED"};
        String[] stringArray2 = new String[]{"SILENCE", "ASLEEP", "POISONED", "PARALYZED", "STONED", "DRAIN", "KNOCK_OUT", "CRITICAL", "DEATH", "BLAZE", "COLD", "ELECTRIC", "HOLY", "NONE"};
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 35;
        int n3 = n2 + this.Gm.ABILITY.length + 1;
        for (int i = 0; i < n3; ++i) {
            int n4;
            string = "";
            if (i == 0) {
                if (this.Light) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_LIGHT");
                }
            } else if (i == 1) {
                if (this.Identify != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_IDENTIFY");
                }
            } else if (i == 2) {
                if (!this.FlyingEffect.equals("")) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_FLYING");
                }
            } else if (i == 3) {
                if (this.AcPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_PROTECT");
                }
            } else if (i == 4) {
                if (this.SResistPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_SPELL_RESIST");
                }
            } else if (i == 5) {
                if (this.BResistPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_BREATH_RESIST");
                }
            } else if (i == 6) {
                if (this.SpellCancelPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_SPELL_CANCEL");
                }
            } else if (i == 7) {
                if (this.HitPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_HIT_RATE");
                }
            } else if (i == 8) {
                if (this.AtCountPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SEPLL_EF_ATTACK_COUNT");
                }
            } else if (i == 9) {
                if (this.AddDmgPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_ADDITIONAL_DAMAGE");
                }
            } else if (i == 10) {
                if (this.TmpHp != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_TEMPORARY_CHANGE_MAX_HP");
                }
            } else if (i == 11) {
                if (this.HealPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_HEAL");
                }
            } else if (i == 12) {
                if (this.Preemptive != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_PREEMPTIVE");
                }
            } else if (i == 13) {
                if (this.SecretDoor != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_DETECT_SECRET_DOOR");
                }
            } else if (i == 14) {
                if (this.LockedDoor != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_OPEN_LOCKED_DOOR");
                }
            } else if (i == 15) {
                if (this.EncounterPlus != 0) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_ENCOUNTER_RATE");
                }
            } else if (i < 22) {
                n4 = i - 16;
                if (this.AttackAddPlus[n4]) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_ENCHANTED_" + stringArray[n4]);
                }
            } else if (i < 36) {
                n4 = i - 22;
                if (this.ResistPlus[n4] == 1) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_RESIST_" + stringArray2[n4]);
                } else if (this.ResistPlus[n4] == 0 || this.ResistPlus[n4] == -1) {
                    string = this.Gm.DEFAULT_MESAGE.get("SPELL_EF_NON_RESIST_" + stringArray2[n4]);
                }
            } else {
                n4 = i - n2 - 1;
                if (!(this.AbiPlus[n4] == 0 || this.Gm.ABILITY_NOT_DISPLAY[n4] && this.Gm.MODIFYING_EFFECTS_ON_HIDDEN_ABILITY_ARE_NOT_DISPLAYED || mainPanel.strCount(string = this.Gm.ABILITY[n4]) <= 14)) {
                    string = this.Gm.ABILITY_ABBR[n4];
                }
            }
            if (string.equals("") || string.equals("none")) continue;
            string = mainPanel.strCut(string, 14);
            if (this.Gm.EFFECT_TIME_IS_INDICATED) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.append(" ");
                stringBuffer2.append(this.spellEffectStrEffectTime(i, n2));
                if (n % 2 == 1) {
                    stringBuffer.append(mainPanel.strLengthFitBack(stringBuffer2.toString(), 22));
                } else {
                    stringBuffer.append("<br>");
                    stringBuffer.append(mainPanel.strLengthFitBack(stringBuffer2.toString(), 22));
                    stringBuffer.append("  ");
                }
            } else {
                n4 = mainPanel.strCount(string);
                if (n4 < 11) {
                    string = mainPanel.strLengthFitBack(string, 10);
                }
                stringBuffer.append("<br>");
                stringBuffer.append(string);
            }
            if (++n >= 14) break;
        }
        if (this.Gm.EFFECT_TIME_IS_INDICATED && n == 1) {
            stringBuffer.append(mainPanel.strLengthFit("", 22));
        }
        string = this.Gm.replaceFirstStr(stringBuffer.toString(), "<br>", "");
        return string;
    }

    private String spellEffectStrEffectTime(int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{"vision", "identifyCount", "flying", "protect", "spellResist", "breathResist", "spellCancelRate", "hitRate", "atCountRate", "addDmgRate", "tmpHpRate", "healRate", "preemptiveCount", "secretDoorRate", "lockedDoorRate", "encounterRate"};
        if (n <= 15) {
            n3 = this.getValue(stringArray[n]);
        } else if (n <= 21) {
            int n4 = n - 15 - 1;
            n3 = this.getValue("attackAddRate", n4);
        } else if (n <= 35) {
            int n5 = n - 21 - 1;
            n3 = this.getValue("resistRate", n5);
        } else {
            int n6 = n - 35 - 1;
            n3 = this.getValue("abiRate", n6);
        }
        if (n3 == 1001 || n3 == -1001) {
            stringBuffer.append("(");
            stringBuffer.append(this.Gm.FRAME.MP.strCut(this.Gm.DEFAULT_MESAGE.get("EFFECT_TIME_ONLY_FLOOR"), 5));
            stringBuffer.append(")");
        } else if (n3 > 0 && n3 <= 1000 || n3 < 0 && n3 >= -1000) {
            stringBuffer.append("(");
            if (n3 < 0) {
                n3 *= -1;
            }
            stringBuffer.append(String.valueOf(n3));
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public int doorsProb(int n, String string) {
        String string2 = n == 1 ? this.Gm.FIND_DOOR_PROB[1] : (n == 2 ? this.Gm.PICK_DOOR_PROB : this.Gm.FIND_DOOR_PROB[0]);
        String string3 = this.Gm.replaceStr(string2, "trap\\.lv", string);
        int n2 = this.getMemberNum();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.Gm.PC[this.PartyMember[i]].getValue("state") == 0 ? this.Gm.pcCalculation(string3, this.PartyMember[i]) : 0;
        }
        Arrays.sort(nArray);
        return nArray[nArray.length - 1];
    }

    public int[] highProbPc(String string, String string2) {
        int n;
        String string3 = this.Gm.replaceStr(string, "trap\\.lv", string2);
        int n2 = this.getMemberNum();
        int[] nArray = new int[n2];
        int n3 = n2 - 1;
        for (n = 0; n < n2; ++n) {
            if (this.Gm.PC[this.PartyMember[n]].getValue("state") == 0) {
                nArray[n] = this.Gm.pcCalculation(string3, this.PartyMember[n]);
                if (nArray[n] > 100) {
                    nArray[n] = 100;
                } else if (nArray[n] < 0) {
                    nArray[n] = 0;
                }
            } else {
                nArray[n] = 0;
            }
            nArray[n] = nArray[n] * 10 + n3;
            --n3;
        }
        Arrays.sort(nArray);
        int[] nArray2 = new int[n2];
        n3 = n2 - 1;
        for (n = 0; n < n2; ++n) {
            nArray[n] = nArray[n] % 1000 % 100 % 10;
            nArray2[n3] = n2 - 1 - nArray[n];
            --n3;
        }
        return nArray2;
    }

    public String ptReplace(String string) {
        int n = this.getMemberNum();
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (this.Gm.PC[this.PartyMember[i]].getValue("state") >= 2 || this.Gm.PC[this.PartyMember[i]].getValue("asleep") != 0) continue;
            arrayList.add(i);
            ++n2;
        }
        if (n2 == 0) {
            return string;
        }
        string = this.Gm.replaceStr(string, "pt\\.abi2\\[", "pt.abi[");
        string = this.Gm.replaceStr(string, "pt\\.maxAbi2\\[", "pt.maxAbi[");
        string = this.Gm.replaceStr(string, "pt\\.minAbi2\\[", "pt.minAbi[");
        while (true) {
            int n3;
            String string2;
            Object object;
            String string3;
            String string4 = "";
            String string5 = "";
            int n4 = 0;
            if (string4.equals("") && string.matches(".*(pt\\.classCommentNum\\[(.+)\\]).*")) {
                string4 = "continue";
                string3 = this.Gm.replaceStr(string, ".*(pt\\.classCommentNum\\[(.+)\\]).*", "$2");
                object = this.Gm.replaceBrackets("de", string3);
                n4 = this.classCommentNum((String)object);
                string = this.Gm.replaceStr(string, "pt\\.classCommentNum\\[" + this.Gm.escapeProcessing(string3) + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.raceCommentNum\\[(.+)\\]).*")) {
                string4 = "continue";
                string3 = this.Gm.replaceStr(string, ".*(pt\\.raceCommentNum\\[(.+)\\]).*", "$2");
                object = this.Gm.replaceBrackets("de", string3);
                n4 = this.raceCommentNum((String)object);
                string = this.Gm.replaceStr(string, "pt\\.raceCommentNum\\[" + this.Gm.escapeProcessing(string3) + "\\]", String.valueOf(n4));
            }
            if (string4.equals("")) {
                string3 = ".*pt\\.itemCommentNum\\[(.+)\\]\\[([0-9]+)\\].*";
                object = Pattern.compile(string3);
                Matcher matcher = ((Pattern)object).matcher(string);
                if (matcher.matches()) {
                    string4 = "continue";
                    String string6 = matcher.group(1);
                    string2 = this.Gm.replaceBrackets("de", string6);
                    n3 = Integer.parseInt(matcher.group(2));
                    n4 = this.itemCommentNum(string2, n3);
                    string = this.Gm.replaceStr(string, "pt\\.itemCommentNum\\[" + this.Gm.escapeProcessing(string6) + "\\]\\[" + n3 + "\\]", String.valueOf(n4));
                }
                string = this.Gm.replaceStr(string, "pt\\.itemCommentNum\\[[^\\[\\]]*\\]\\[[0-9]*\\]", "0");
            }
            if (string4.equals("")) {
                if (string.indexOf("pt.lv") > -1) {
                    string4 = "level";
                    string5 = "lv";
                } else if (string.indexOf("pt.maxLv") > -1) {
                    string4 = "level";
                    string5 = "maxLv";
                } else if (string.indexOf("pt.minLv") > -1) {
                    string4 = "level";
                    string5 = "minLv";
                } else if (string.indexOf("pt.hpMax0") > -1) {
                    string4 = "hpMax0";
                    string5 = "hpMax0";
                } else if (string.indexOf("pt.maxHpMax0") > -1) {
                    string4 = "hpMax0";
                    string5 = "maxHpMax0";
                } else if (string.indexOf("pt.minHpMax0") > -1) {
                    string4 = "hpMax0";
                    string5 = "minHpMax0";
                } else if (string.indexOf("pt.hpMax") > -1) {
                    string4 = "hpMax";
                    string5 = "hpMax";
                } else if (string.indexOf("pt.maxHpMax") > -1) {
                    string4 = "hpMax";
                    string5 = "maxHpMax";
                } else if (string.indexOf("pt.minHpMax") > -1) {
                    string4 = "hpMax";
                    string5 = "minHpMax";
                } else if (string.indexOf("pt.hp") > -1) {
                    string4 = "hp";
                    string5 = "hp";
                } else if (string.indexOf("pt.maxHp") > -1) {
                    string4 = "hp";
                    string5 = "maxHp";
                } else if (string.indexOf("pt.minHp") > -1) {
                    string4 = "hp";
                    string5 = "minHp";
                } else if (string.indexOf("pt.ac0") > -1) {
                    string4 = "ac0";
                    string5 = "ac0";
                } else if (string.indexOf("pt.maxAc0") > -1) {
                    string4 = "ac0";
                    string5 = "maxAc0";
                } else if (string.indexOf("pt.minAc0") > -1) {
                    string4 = "ac0";
                    string5 = "minAc0";
                } else if (string.indexOf("pt.ac1") > -1) {
                    string4 = "ac1";
                    string5 = "ac1";
                } else if (string.indexOf("pt.maxAc1") > -1) {
                    string4 = "ac1";
                    string5 = "maxAc1";
                } else if (string.indexOf("pt.minAc1") > -1) {
                    string4 = "ac1";
                    string5 = "minAc1";
                } else if (string.indexOf("pt.ac") > -1) {
                    string4 = "ac";
                    string5 = "ac";
                } else if (string.indexOf("pt.maxAc") > -1) {
                    string4 = "ac";
                    string5 = "maxAc";
                } else if (string.indexOf("pt.minAc") > -1) {
                    string4 = "ac";
                    string5 = "minAc";
                } else if (string.indexOf("pt.spellCancel") > -1) {
                    string4 = "spellCancel";
                    string5 = "spellCancel";
                } else if (string.indexOf("pt.maxSpellCancel") > -1) {
                    string4 = "spellCancel";
                    string5 = "maxSpellCancel";
                } else if (string.indexOf("pt.minSpellCancel") > -1) {
                    string4 = "spellCancel";
                    string5 = "minSpellCancel";
                } else if (string.indexOf("pt.sc0") > -1) {
                    string4 = "sc0";
                    string5 = "sc0";
                } else if (string.indexOf("pt.maxSc0") > -1) {
                    string4 = "sc0";
                    string5 = "maxSc0";
                } else if (string.indexOf("pt.minSc0") > -1) {
                    string4 = "sc0";
                    string5 = "minSc0";
                } else if (string.indexOf("pt.sc1") > -1) {
                    string4 = "sc1";
                    string5 = "sc1";
                } else if (string.indexOf("pt.maxSc1") > -1) {
                    string4 = "sc1";
                    string5 = "maxSc1";
                } else if (string.indexOf("pt.minSc1") > -1) {
                    string4 = "sc1";
                    string5 = "minSc1";
                } else if (string.indexOf("pt.sc") > -1) {
                    string4 = "spellCancel";
                    string5 = "sc";
                } else if (string.indexOf("pt.maxSc") > -1) {
                    string4 = "spellCancel";
                    string5 = "maxSc";
                } else if (string.indexOf("pt.minSc") > -1) {
                    string4 = "spellCancel";
                    string5 = "minSc";
                } else if (string.indexOf("pt.age") > -1) {
                    string4 = "age";
                    string5 = "age";
                } else if (string.indexOf("pt.maxAge") > -1) {
                    string4 = "age";
                    string5 = "maxAge";
                } else if (string.indexOf("pt.minAge") > -1) {
                    string4 = "age";
                    string5 = "minAge";
                } else if (string.indexOf("pt.rip") > -1) {
                    string4 = "rip";
                    string5 = "rip";
                } else if (string.indexOf("pt.maxRip") > -1) {
                    string4 = "rip";
                    string5 = "maxRip";
                } else if (string.indexOf("pt.minRip") > -1) {
                    string4 = "rip";
                    string5 = "minRip";
                } else if (string.indexOf("pt.marks") > -1) {
                    string4 = "marks";
                    string5 = "marks";
                } else if (string.indexOf("pt.maxMarks") > -1) {
                    string4 = "marks";
                    string5 = "maxMarks";
                } else if (string.indexOf("pt.minMarks") > -1) {
                    string4 = "marks";
                    string5 = "minMarks";
                } else if (string.indexOf("pt.gold") > -1) {
                    string4 = "gold";
                    string5 = "gold";
                } else if (string.indexOf("pt.maxGold") > -1) {
                    string4 = "gold";
                    string5 = "maxGold";
                } else if (string.indexOf("pt.minGold") > -1) {
                    string4 = "gold";
                    string5 = "minGold";
                } else if (string.indexOf("pt.exp") > -1) {
                    string4 = "exp";
                    string5 = "exp";
                } else if (string.indexOf("pt.maxExp") > -1) {
                    string4 = "exp";
                    string5 = "maxExp";
                } else if (string.indexOf("pt.minExp") > -1) {
                    string4 = "exp";
                    string5 = "minExp";
                } else if (string.indexOf("pt.Sex[0]") > -1) {
                    string4 = "sex";
                    n4 = 0;
                    string5 = "Sex\\[0\\]";
                } else if (string.indexOf("pt.Sex[1]") > -1) {
                    string4 = "sex";
                    n4 = 1;
                    string5 = "Sex\\[1\\]";
                } else if (string.indexOf("pt.Sex[2]") > -1) {
                    string4 = "sex";
                    n4 = 2;
                    string5 = "Sex\\[2\\]";
                } else if (string.indexOf("pt.Sex[3]") > -1) {
                    string4 = "sex";
                    n4 = 3;
                    string5 = "Sex\\[3\\]";
                } else if (string.indexOf("pt.Ali[0]") > -1) {
                    string4 = "alignment";
                    n4 = 0;
                    string5 = "Ali\\[0\\]";
                } else if (string.indexOf("pt.Ali[1]") > -1) {
                    string4 = "alignment";
                    n4 = 1;
                    string5 = "Ali\\[1\\]";
                } else if (string.indexOf("pt.Ali[2]") > -1) {
                    string4 = "alignment";
                    n4 = 2;
                    string5 = "Ali\\[2\\]";
                }
            }
            if (string4.equals("")) {
                for (int i = 0; i < this.Gm.ABILITY.length; ++i) {
                    if (string.indexOf("pt.abi0[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability0";
                        n4 = i;
                        string5 = "abi0\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.maxAbi0[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability0";
                        n4 = i;
                        string5 = "maxAbi0\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.minAbi0[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability0";
                        n4 = i;
                        string5 = "minAbi0\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.abi1[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability1";
                        n4 = i;
                        string5 = "abi1\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.maxAbi1[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability1";
                        n4 = i;
                        string5 = "maxAbi1\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.minAbi1[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability1";
                        n4 = i;
                        string5 = "minAbi1\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.abi[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability";
                        n4 = i;
                        string5 = "abi\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.maxAbi[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability";
                        n4 = i;
                        string5 = "maxAbi\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.minAbi[" + String.valueOf(i) + "]") > -1) {
                        string4 = "ability";
                        n4 = i;
                        string5 = "minAbi\\[" + String.valueOf(i) + "\\]";
                    }
                    if (!string4.equals("")) break;
                }
            }
            if (string4.equals("")) {
                for (int i = 0; i < 10; ++i) {
                    if (string.indexOf("pt.gm[" + String.valueOf(i) + "]") > -1) {
                        string4 = "gm";
                        n4 = i;
                        string5 = "gm\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.maxGm[" + String.valueOf(i) + "]") > -1) {
                        string4 = "gm";
                        n4 = i;
                        string5 = "maxGm\\[" + String.valueOf(i) + "\\]";
                    } else if (string.indexOf("pt.minGm[" + String.valueOf(i) + "]") > -1) {
                        string4 = "gm";
                        n4 = i;
                        string5 = "minGm\\[" + String.valueOf(i) + "\\]";
                    }
                    if (!string4.equals("")) break;
                }
            }
            if (string4.equals("")) {
                for (int i = 0; i < this.Gm.RACE.length; ++i) {
                    if (string.indexOf("pt.Race[" + String.valueOf(i) + "]") <= -1) continue;
                    string4 = "race";
                    n4 = i;
                    string5 = "Race\\[" + String.valueOf(i) + "\\]";
                    break;
                }
            }
            if (string4.equals("")) {
                for (int i = 0; i < this.Gm.PC_CLASS.length; ++i) {
                    if (string.indexOf("pt.Class[" + String.valueOf(i) + "]") <= -1) continue;
                    string4 = "pcClass";
                    n4 = i;
                    string5 = "Class\\[" + String.valueOf(i) + "\\]";
                    break;
                }
            }
            if (string4.equals("")) {
                for (int i = 1; i <= 6; ++i) {
                    if (string.indexOf("pt.MemberNum[" + String.valueOf(i) + "]") <= -1) continue;
                    string4 = "continue";
                    n4 = i == this.possibleToAction() ? 1 : 0;
                    string = this.Gm.replaceStr(string, "pt\\.MemberNum\\[" + String.valueOf(i) + "\\]", String.valueOf(n4));
                    break;
                }
            }
            if (string4.equals("") && string.indexOf("pt.memberNum") > -1) {
                string4 = "continue";
                n4 = this.possibleToAction();
                string = this.Gm.replaceStr(string, "pt\\.memberNum", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.Direction\\[([0-9])\\]).*")) {
                string4 = "continue";
                n4 = 0;
                String string7 = this.Gm.replaceStr(string, ".*(pt\\.Direction\\[([0-9])\\]).*", "$2");
                int n5 = Integer.parseInt(string7) - 1;
                if (this.DungeonNumber > -1 && this.Direction == n5) {
                    n4 = 1;
                }
                string = this.Gm.replaceStr(string, "pt\\.Direction\\[" + string7 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.indexOf("pt.direction") > -1) {
                string4 = "continue";
                n4 = 0;
                if (this.DungeonNumber > -1) {
                    n4 = this.Direction + 1;
                }
                string = this.Gm.replaceStr(string, "pt\\.direction", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.haveItemNum\\[([0-9]+)\\]\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string8 = this.Gm.replaceStr(string, ".*(pt\\.haveItemNum\\[([0-9]+)\\]\\[([0-9]+)\\]).*", "$2,$3");
                String[] stringArray = string8.split(",");
                n4 = this.haveItemNum(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                string = this.Gm.replaceStr(string, "pt\\.haveItemNum\\[" + stringArray[0] + "\\]\\[" + stringArray[1] + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.Resist1\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string9 = this.Gm.replaceStr(string, ".*(pt\\.Resist1\\[([0-9]+)\\]).*", "$2");
                n4 = this.getResist(Integer.parseInt(string9), 1);
                string = this.Gm.replaceStr(string, "pt\\.Resist1\\[" + string9 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.Resist0\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string10 = this.Gm.replaceStr(string, ".*(pt\\.Resist0\\[([0-9]+)\\]).*", "$2");
                n4 = this.getResist(Integer.parseInt(string10), 0);
                string = this.Gm.replaceStr(string, "pt\\.Resist0\\[" + string10 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.Resist\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string11 = this.Gm.replaceStr(string, ".*(pt\\.Resist\\[([0-9]+)\\]).*", "$2");
                n4 = this.getResist(Integer.parseInt(string11), -1);
                string = this.Gm.replaceStr(string, "pt\\.Resist\\[" + string11 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.indexOf("pt.BreathBarrier") > -1) {
                string4 = "continue";
                n4 = this.getBreathBarrier(true);
                n4 = n4 > 0 ? 1 : 0;
                string = this.Gm.replaceStr(string, "pt\\.BreathBarrier", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.MasteredSpell\\[(-?[0-9]+)\\]\\[(-?[0-9]+)\\]\\[(-?[0-9]+)\\]).*")) {
                string4 = "continue";
                String string12 = this.Gm.replaceStr(string, ".*(pt\\.MasteredSpell\\[(-?[0-9]+)\\]\\[(-?[0-9]+)\\]\\[(-?[0-9]+)\\]).*", "$2,$3,$4");
                String[] stringArray = string12.split(",");
                n4 = this.spellMaster(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
                string = this.Gm.replaceStr(string, "pt\\.MasteredSpell\\[" + stringArray[0] + "\\]\\[" + stringArray[1] + "\\]\\[" + stringArray[2] + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.MasteredSpell\\[(-?[0-9]+)\\]\\[(-?[0-9]+)\\]).*")) {
                string4 = "continue";
                String string13 = this.Gm.replaceStr(string, ".*(pt\\.MasteredSpell\\[(-?[0-9]+)\\]\\[(-?[0-9]+)\\]).*", "$2,$3");
                String[] stringArray = string13.split(",");
                n4 = this.spellMaster(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), -1);
                string = this.Gm.replaceStr(string, "pt\\.MasteredSpell\\[" + stringArray[0] + "\\]\\[" + stringArray[1] + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.MasteredSpell\\[(-?[0-9]+)\\]).*")) {
                string4 = "continue";
                String string14 = this.Gm.replaceStr(string, ".*(pt\\.MasteredSpell\\[(-?[0-9]+)\\]).*", "$2");
                n4 = this.spellMaster(Integer.parseInt(string14), -1, -1);
                string = this.Gm.replaceStr(string, "pt\\.MasteredSpell\\[" + string14 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.MasteredSpell).*")) {
                string4 = "continue";
                n4 = this.spellMaster(-1, -1, -1);
                string = this.Gm.replaceStr(string, "pt\\.MasteredSpell", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.spaceNum).*")) {
                string4 = "continue";
                n4 = this.Gm.PARTY_MEMBER_MAX - this.getMemberNum();
                string = this.Gm.replaceStr(string, "pt\\.spaceNum", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.stateNum\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string15 = this.Gm.replaceStr(string, ".*(pt\\.stateNum\\[([0-9]+)\\]).*", "$2");
                n4 = Integer.parseInt(string15);
                n4 = this.getPossibleToActionMemberState(n4);
                string = this.Gm.replaceStr(string, "pt\\.stateNum\\[" + string15 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.State\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string16 = this.Gm.replaceStr(string, ".*(pt\\.State\\[([0-9]+)\\]).*", "$2");
                n4 = Integer.parseInt(string16);
                n4 = this.getPossibleToActionMemberState(n4) > 0 ? 1 : 0;
                string = this.Gm.replaceStr(string, "pt\\.State\\[" + string16 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.attackAddNum\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string17 = this.Gm.replaceStr(string, ".*(pt\\.attackAddNum\\[([0-9]+)\\]).*", "$2");
                n4 = Integer.parseInt(string17);
                n4 = this.getMemberAttackAdd(n4, true);
                string = this.Gm.replaceStr(string, "pt\\.attackAddNum\\[" + string17 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("") && string.matches(".*(pt\\.AttackAdd\\[([0-9]+)\\]).*")) {
                string4 = "continue";
                String string18 = this.Gm.replaceStr(string, ".*(pt\\.AttackAdd\\[([0-9]+)\\]).*", "$2");
                n4 = Integer.parseInt(string18);
                n4 = this.getMemberAttackAdd(n4, true) > 0 ? 1 : 0;
                string = this.Gm.replaceStr(string, "pt\\.AttackAdd\\[" + string18 + "\\]", String.valueOf(n4));
            }
            if (string4.equals("continue")) continue;
            if (string4.equals("")) break;
            long[] lArray = new long[n2];
            double[] dArray = new double[n2];
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (string4.matches("marks|gold|exp")) {
                    lArray[i] = this.Gm.PC[this.PartyMember[(Integer)arrayList.get(i)]].getValueLong(string4);
                    continue;
                }
                if (string4.matches("ability|ability0|ability1")) {
                    lArray[i] = this.Gm.PC[this.PartyMember[(Integer)arrayList.get(i)]].getValue(string4, n4);
                    continue;
                }
                if (string4.matches("sex|alignment|race|pcClass")) {
                    if (this.Gm.PC[this.PartyMember[(Integer)arrayList.get(i)]].getValue(string4) != n4) continue;
                    bl = true;
                    break;
                }
                if (string4.equals("gm")) {
                    string2 = this.Gm.PC[this.PartyMember[(Integer)arrayList.get(i)]].getValueStr("gm", n4);
                    string2 = this.Gm.substitutionPcGm(string2, "pc", this.PartyMember[(Integer)arrayList.get(i)]);
                    dArray[i] = this.Gm.strCalculation(string2);
                    continue;
                }
                lArray[i] = this.Gm.PC[this.PartyMember[(Integer)arrayList.get(i)]].getValue(string4);
            }
            if (string4.equals("gm")) {
                Arrays.sort(dArray);
                double d = 0.0;
                if (string5.indexOf("min") > -1) {
                    d = dArray[0];
                } else if (string5.indexOf("max") > -1) {
                    d = dArray[n2 - 1];
                } else {
                    for (n3 = 0; n3 < n2; ++n3) {
                        d += dArray[n3];
                    }
                    d /= (double)n2;
                }
                string = this.Gm.replaceStr(string, "pt\\." + string5, String.valueOf(d));
                continue;
            }
            Arrays.sort(lArray);
            long l = 0L;
            if (string5.indexOf("min") > -1) {
                l = lArray[0];
            } else if (string5.indexOf("max") > -1) {
                l = lArray[n2 - 1];
            } else if (string4.matches("sex|alignment|race|pcClass")) {
                l = bl ? 1L : 0L;
            } else {
                for (n3 = 0; n3 < n2; ++n3) {
                    l += lArray[n3];
                }
                l /= (long)n2;
            }
            string = this.Gm.replaceStr(string, "pt\\." + string5, String.valueOf(l));
        }
        return string;
    }

    public int averageLevel(int n) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = this.getMemberNum();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.Gm.PC[this.PartyMember[i]].getValue("state");
            int n4 = this.Gm.PC[this.PartyMember[i]].getValue("asleep");
            int n5 = this.Gm.PC[this.PartyMember[i]].getValue("level");
            if (n == 1) {
                if (n3 >= 4) continue;
                d += (double)n5;
                d2 += 1.0;
                continue;
            }
            if (n == 2) {
                if (n3 != 0 || n4 != 0) continue;
                d += (double)n5;
                d2 += 1.0;
                continue;
            }
            d += (double)n5;
            d2 += 1.0;
        }
        if (d2 == 0.0) {
            return 0;
        }
        return (int)Math.floor(d / d2);
    }

    public int possibleToAction() {
        int n = 0;
        int n2 = this.getMemberNum();
        for (int i = 0; i < n2; ++i) {
            if (!this.Gm.PC[this.PartyMember[i]].possibleToAction()) continue;
            ++n;
        }
        return n;
    }

    public int getBreathBarrier(boolean bl) {
        int n = 0;
        int n2 = this.getMemberNum();
        for (int i = 0; i < n2; ++i) {
            if (bl && !this.Gm.PC[this.PartyMember[i]].possibleToAction() || this.Gm.PC[this.PartyMember[i]].getValue("breathBarrier") <= 0) continue;
            ++n;
        }
        return n;
    }

    public int boxSpell() {
        int n = -1;
        int n2 = this.getMemberNum();
        for (int i = 0; i < n2; ++i) {
            if (this.Gm.PC[this.PartyMember[i]].boxSpell() <= -1) continue;
            n = i;
            break;
        }
        return n;
    }

    public int boxItem() {
        int n = -1;
        int n2 = this.getMemberNum();
        for (int i = 0; i < n2; ++i) {
            if (this.Gm.PC[this.PartyMember[i]].boxItem() <= 0) continue;
            n = i;
            break;
        }
        return n;
    }

    public int boxTrapMember(String string) {
        int n;
        int[] nArray = new int[this.possibleToAction()];
        int n2 = 0;
        int n3 = this.getMemberNum();
        for (n = 0; n < n3; ++n) {
            if (!this.Gm.PC[this.PartyMember[n]].possibleToAction()) continue;
            int n4 = this.Gm.pcCalculation(string, this.Gm.PC[this.PartyMember[n]].PC_NUM);
            if (n4 > 100) {
                n4 = 100;
            } else if (n4 < 0) {
                n4 = 0;
            }
            n4 = 100 - n4;
            nArray[n2] = n4 * 10 + n;
            ++n2;
        }
        Arrays.sort(nArray);
        n = nArray[0] % 10;
        return n;
    }

    public boolean conditionCheckPc(String string, int n, boolean bl) {
        boolean bl2 = false;
        int n2 = this.getMemberNum();
        for (int i = 0; i < n2; ++i) {
            if (string.indexOf("sex") > -1) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("sex") != n) continue;
                if (bl) {
                    if (!this.Gm.PC[this.PartyMember[i]].possibleToAction()) continue;
                    bl2 = true;
                    break;
                }
                bl2 = true;
                break;
            }
            if (string.indexOf("alignment") > -1) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("alignment") != n) continue;
                if (bl) {
                    if (!this.Gm.PC[this.PartyMember[i]].possibleToAction()) continue;
                    bl2 = true;
                    break;
                }
                bl2 = true;
                break;
            }
            if (string.indexOf("race") > -1) {
                if (this.Gm.PC[this.PartyMember[i]].getValue("race") != n) continue;
                if (bl) {
                    if (!this.Gm.PC[this.PartyMember[i]].possibleToAction()) continue;
                    bl2 = true;
                    break;
                }
                bl2 = true;
                break;
            }
            if (string.indexOf("class") <= -1 || this.Gm.PC[this.PartyMember[i]].getValue("pcClass") != n) continue;
            if (bl) {
                if (!this.Gm.PC[this.PartyMember[i]].possibleToAction()) continue;
                bl2 = true;
                break;
            }
            bl2 = true;
            break;
        }
        return bl2;
    }

    public void sortNoAction(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = new int[this.PartyMember.length];
        if (string.equals("")) {
            n4 = nArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = this.PartyMember[n3];
            }
        } else {
            String[] stringArray = string.split(",");
            n4 = stringArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = Integer.parseInt(stringArray[n3]);
            }
        }
        n4 = nArray.length;
        for (n3 = 0; n3 < n4 && nArray[n3] != -1; ++n3) {
            n2 = this.Gm.PC[nArray[n3]].getValue("state");
            n = this.Gm.PC[nArray[n3]].getValue("asleep");
            if (n2 >= 2 || n != 0) continue;
            arrayList.add(nArray[n3]);
        }
        for (n3 = 0; n3 < n4 && nArray[n3] != -1; ++n3) {
            n2 = this.Gm.PC[nArray[n3]].getValue("state");
            n = this.Gm.PC[nArray[n3]].getValue("asleep");
            if (n2 != 2 && n2 != 3 && n == 0) continue;
            arrayList.add(nArray[n3]);
        }
        for (n3 = 0; n3 < n4 && nArray[n3] != -1; ++n3) {
            n2 = this.Gm.PC[nArray[n3]].getValue("state");
            if (n2 <= 3) continue;
            arrayList.add(nArray[n3]);
        }
        n3 = 0;
        while (arrayList.size() > 0) {
            this.setMember(n3, (Integer)arrayList.get(0));
            arrayList.remove(0);
            ++n3;
        }
    }

    public String itemDecidedList(int n) {
        int n2;
        int n3;
        int n4;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.Gm.PC[this.PartyMember[n]].itemDecidedList(true);
        if (!string.equals("")) {
            stringArray = string.split(",");
            n4 = stringArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n * 100 + Integer.parseInt(stringArray[n3]);
                stringBuffer.append(",");
                stringBuffer.append(String.valueOf(n2));
            }
        }
        n4 = this.getMemberNum();
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 == n || (string = this.Gm.IDENTIFY_NOT_CURSED ? this.Gm.PC[this.PartyMember[n3]].itemDecidedList(true) : this.Gm.PC[this.PartyMember[n3]].itemDecidedList(false)).equals("")) continue;
            stringArray = string.split(",");
            n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                int n5 = n3 * 100 + Integer.parseInt(stringArray[i]);
                stringBuffer.append(",");
                stringBuffer.append(String.valueOf(n5));
            }
        }
        return this.Gm.replaceStr(stringBuffer.toString(), "^,", "");
    }

    public boolean checkAnnihilation() {
        boolean bl = true;
        int n = this.getMemberNum();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getMember(i);
            if (this.Gm.PC[n2].getValue("state") >= 2 || this.Gm.PC[n2].getValue("asleep") <= -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void actionReset() {
        int n = this.getMemberNum();
        for (int i = 0; i < n; ++i) {
            this.Gm.PC[this.PartyMember[i]].actionReset();
        }
    }

    public void reset() {
        int n = this.getMemberNum();
        for (int i = 0; i < n; ++i) {
            this.Gm.PC[this.PartyMember[i]].reset();
        }
    }
}

