/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AudioFileWriter {
    public abstract void close() throws IOException;

    public abstract void open(File var1) throws IOException;

    public abstract void open(String var1) throws IOException;

    public abstract void writeHeader(String var1) throws IOException;

    public abstract void writePacket(byte[] var1, int var2, int var3) throws IOException;

    public static int writeOggPageHeader(byte[] byArray, int n, int n2, long l, int n3, int n4, int n5, byte[] byArray2) {
        AudioFileWriter.writeString(byArray, n, "OggS");
        byArray[n + 4] = 0;
        byArray[n + 5] = (byte)n2;
        AudioFileWriter.writeLong(byArray, n + 6, l);
        AudioFileWriter.writeInt(byArray, n + 14, n3);
        AudioFileWriter.writeInt(byArray, n + 18, n4);
        AudioFileWriter.writeInt(byArray, n + 22, 0);
        byArray[n + 26] = (byte)n5;
        System.arraycopy(byArray2, 0, byArray, n + 27, n5);
        return n5 + 27;
    }

    public static byte[] buildOggPageHeader(int n, long l, int n2, int n3, int n4, byte[] byArray) {
        byte[] byArray2 = new byte[n4 + 27];
        AudioFileWriter.writeOggPageHeader(byArray2, 0, n, l, n2, n3, n4, byArray);
        return byArray2;
    }

    public static int writeSpeexHeader(byte[] byArray, int n, int n2, int n3, int n4, boolean bl, int n5) {
        AudioFileWriter.writeString(byArray, n, "Speex   ");
        AudioFileWriter.writeString(byArray, n + 8, "speex-1.0");
        System.arraycopy(new byte[11], 0, byArray, n + 17, 11);
        AudioFileWriter.writeInt(byArray, n + 28, 1);
        AudioFileWriter.writeInt(byArray, n + 32, 80);
        AudioFileWriter.writeInt(byArray, n + 36, n2);
        AudioFileWriter.writeInt(byArray, n + 40, n3);
        AudioFileWriter.writeInt(byArray, n + 44, 4);
        AudioFileWriter.writeInt(byArray, n + 48, n4);
        AudioFileWriter.writeInt(byArray, n + 52, -1);
        AudioFileWriter.writeInt(byArray, n + 56, 160 << n3);
        AudioFileWriter.writeInt(byArray, n + 60, bl ? 1 : 0);
        AudioFileWriter.writeInt(byArray, n + 64, n5);
        AudioFileWriter.writeInt(byArray, n + 68, 0);
        AudioFileWriter.writeInt(byArray, n + 72, 0);
        AudioFileWriter.writeInt(byArray, n + 76, 0);
        return 80;
    }

    public static byte[] buildSpeexHeader(int n, int n2, int n3, boolean bl, int n4) {
        byte[] byArray = new byte[80];
        AudioFileWriter.writeSpeexHeader(byArray, 0, n, n2, n3, bl, n4);
        return byArray;
    }

    public static int writeSpeexComment(byte[] byArray, int n, String string) {
        int n2 = string.length();
        AudioFileWriter.writeInt(byArray, n, n2);
        AudioFileWriter.writeString(byArray, n + 4, string);
        AudioFileWriter.writeInt(byArray, n + n2 + 4, 0);
        return n2 + 8;
    }

    public static byte[] buildSpeexComment(String string) {
        byte[] byArray = new byte[string.length() + 8];
        AudioFileWriter.writeSpeexComment(byArray, 0, string);
        return byArray;
    }

    public static void writeShort(DataOutput dataOutput, short s) throws IOException {
        dataOutput.writeByte(0xFF & s);
        dataOutput.writeByte(0xFF & s >>> 8);
    }

    public static void writeInt(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeByte(0xFF & n);
        dataOutput.writeByte(0xFF & n >>> 8);
        dataOutput.writeByte(0xFF & n >>> 16);
        dataOutput.writeByte(0xFF & n >>> 24);
    }

    public static void writeShort(OutputStream outputStream, short s) throws IOException {
        outputStream.write(0xFF & s);
        outputStream.write(0xFF & s >>> 8);
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(0xFF & n);
        outputStream.write(0xFF & n >>> 8);
        outputStream.write(0xFF & n >>> 16);
        outputStream.write(0xFF & n >>> 24);
    }

    public static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(0xFFL & l));
        outputStream.write((int)(0xFFL & l >>> 8));
        outputStream.write((int)(0xFFL & l >>> 16));
        outputStream.write((int)(0xFFL & l >>> 24));
        outputStream.write((int)(0xFFL & l >>> 32));
        outputStream.write((int)(0xFFL & l >>> 40));
        outputStream.write((int)(0xFFL & l >>> 48));
        outputStream.write((int)(0xFFL & l >>> 56));
    }

    public static void writeShort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(0xFF & n2);
        byArray[n + 1] = (byte)(0xFF & n2 >>> 8);
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(0xFF & n2);
        byArray[n + 1] = (byte)(0xFF & n2 >>> 8);
        byArray[n + 2] = (byte)(0xFF & n2 >>> 16);
        byArray[n + 3] = (byte)(0xFF & n2 >>> 24);
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(0xFFL & l);
        byArray[n + 1] = (byte)(0xFFL & l >>> 8);
        byArray[n + 2] = (byte)(0xFFL & l >>> 16);
        byArray[n + 3] = (byte)(0xFFL & l >>> 24);
        byArray[n + 4] = (byte)(0xFFL & l >>> 32);
        byArray[n + 5] = (byte)(0xFFL & l >>> 40);
        byArray[n + 6] = (byte)(0xFFL & l >>> 48);
        byArray[n + 7] = (byte)(0xFFL & l >>> 56);
    }

    public static void writeString(byte[] byArray, int n, String string) {
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }
}

