/*
 * Decompiled with CFR 0.152.
 */
package classFile;

import classFile.GameMode;
import classFile.Mp3Player;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class GameSound
extends Thread
implements LineListener {
    private GameMode Gm;
    private boolean ThreadStart = true;
    private AudioClip MidiAc = null;
    private HashMap<String, AudioClip> MidiAcHash = new HashMap();
    private HashMap<String, Sequence> MidiSequence = new HashMap();
    private Sequencer Midi = null;
    private Mp3Player Mp3 = null;
    private ArrayList<Mp3Player> SeMp3 = new ArrayList();
    private HashMap<String, AudioClip> Se = new HashMap();
    private HashMap<String, Boolean> SeNow = new HashMap();
    private HashMap<String, Clip> SeClip = new HashMap();
    private HashMap<String, File> SeHashMp3 = new HashMap();
    private HashMap<String, String> Bgm = new HashMap();
    private HashMap<String, String> Bgm2 = new HashMap();
    private boolean BgmPlay = true;
    private boolean Bgm2Play = false;
    private boolean SePlay = true;
    private boolean MidiAcFlag = false;
    private boolean MidiAcHashFlag = false;
    private boolean MidiPlay = false;
    private boolean MusicFirst = false;
    private boolean SeAcFlag = false;
    private String BgmNow = "";
    private String SeStart = "";
    private long MidiTime = 0L;
    private long MidiLength = 0L;
    private int Bgm2SetVolumeCount = 0;

    GameSound(GameMode gameMode, int n, int n2) {
        this.Gm = gameMode;
        if (n < 0) {
            n = 0;
        }
        if (n == 1 || n == 2) {
            this.MidiAcFlag = true;
            if (n == 1) {
                this.MidiAcHashFlag = true;
            }
        }
        if (n == 0) {
            this.Gm.debugPrintln("Play MIDI with Sequencer.");
        } else if (n == 1) {
            this.Gm.debugPrintln("Prefetch and play MIDI with AudioClip.");
        } else if (n == 2) {
            this.Gm.debugPrintln("Play MIDI with AudioClip.");
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 == 1) {
            this.SeAcFlag = true;
        }
        if (n2 == 0) {
            this.Gm.debugPrintln("Play SE(WAVE) with Clip.");
        } else if (n2 == 1) {
            this.Gm.debugPrintln("Play SE(WAVE) with AudioClip.");
        }
        if (!this.MidiAcFlag) {
            try {
                this.Midi = MidiSystem.getSequencer();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
    }

    public String getValueStr(String string) {
        if (string.equals("bgmNow")) {
            return this.BgmNow;
        }
        return "";
    }

    public void runStart() {
        this.start();
    }

    public void offOnSet(String string, boolean bl) {
        if (string.equals("bgm")) {
            if (bl && !this.BgmNow.equals("")) {
                String string2 = this.BgmNow;
                this.BgmNow = "";
                this.bgmPlay(string2);
            } else if (!bl) {
                if (this.MidiPlay) {
                    this.midiStop();
                }
                if (this.Bgm2Play) {
                    this.mp3Stop();
                }
            }
        } else {
            this.SePlay = bl;
            if (!this.SePlay) {
                this.seStop();
            }
        }
    }

    public void bgmSet(String string, String string2) {
        File file;
        StringBuffer stringBuffer;
        int n;
        boolean bl = false;
        String string3 = "mid,MID,midi,MIDI,midDat";
        String[] stringArray = string3.split(",");
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer = new StringBuffer(this.Gm.DIR_PATH + "music/");
            stringBuffer.append(string2);
            stringBuffer.append(".");
            stringBuffer.append(stringArray[n]);
            string3 = stringBuffer.toString();
            file = new File(string3);
            if (!file.exists()) continue;
            this.Bgm.put(string, string3);
            try {
                String string4 = string3.substring(string3.lastIndexOf(".") + 1);
                if (string4.equals("midDat")) {
                    byte[] byArray = this.decryptData(file);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    this.MidiSequence.put(string, MidiSystem.getSequence(byteArrayInputStream));
                    byteArrayInputStream.close();
                    if (this.MidiAcHashFlag) {
                        String string5 = this.Gm.SaveDir + "music.tmp";
                        FileOutputStream fileOutputStream = new FileOutputStream(string5);
                        fileOutputStream.write(byArray);
                        fileOutputStream.close();
                        File file2 = new File(string5);
                        file2.setWritable(false, false);
                        this.MidiAcHash.put(string, Applet.newAudioClip(file2.toURI().toURL()));
                        file2.delete();
                    }
                } else {
                    this.MidiSequence.put(string, MidiSystem.getSequence(file));
                    if (this.MidiAcHashFlag) {
                        this.MidiAcHash.put(string, Applet.newAudioClip(file.toURI().toURL()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = true;
            break;
        }
        if (bl) {
            return;
        }
        string3 = "mp3,MP3,mp3Dat";
        stringArray = string3.split(",");
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer = new StringBuffer(this.Gm.DIR_PATH + "music/");
            stringBuffer.append(string2);
            stringBuffer.append(".");
            stringBuffer.append(stringArray[n]);
            string3 = stringBuffer.toString();
            file = new File(string3);
            if (!file.exists()) continue;
            this.Bgm2.put(string, string3);
            break;
        }
    }

    public void bgmPlay(String string) {
        if (this.BgmNow.equals(string)) {
            return;
        }
        this.BgmNow = string;
        if (!this.Gm.Bgm) {
            return;
        }
        if (this.BgmNow.equals("") || this.BgmNow.equals("none")) {
            this.bgmStop();
            return;
        }
        if (this.BgmPlay) {
            if (this.MidiPlay) {
                this.midiStop();
            }
            if (this.Bgm2Play) {
                this.mp3Stop();
            }
            if (this.Bgm.get(string) != null) {
                File file = new File(this.Bgm.get(string));
                if (!file.exists()) {
                    return;
                }
                if (this.MidiAcFlag) {
                    if (this.MidiAcHashFlag) {
                        if (this.Gm.OS_NAME.indexOf("Linux") > -1 && this.Gm.VM_NAME.indexOf("Java HotSpot") > -1) {
                            this.MidiAcHash.get(this.BgmNow).loop();
                        } else {
                            this.MidiTime = System.currentTimeMillis();
                            this.MidiLength = this.MidiSequence.get(string).getMicrosecondLength() / 1000L;
                            this.MidiAcHash.get(this.BgmNow).play();
                        }
                    } else {
                        this.MusicFirst = true;
                    }
                } else {
                    this.setBgmVolume(this.Gm.BgmVolume);
                    try {
                        this.MusicFirst = true;
                        this.Midi.open();
                        this.Midi.setLoopCount(0);
                        this.Midi.setSequence(this.MidiSequence.get(this.BgmNow));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.MidiPlay = true;
            } else if (this.Bgm2.get(string) != null) {
                File file = new File(this.Bgm2.get(string));
                if (!file.exists()) {
                    return;
                }
                String string2 = this.Bgm2.get(string).substring(this.Bgm2.get(string).lastIndexOf(".") + 1);
                if (string2.equals("mp3Dat")) {
                    String string3 = this.Gm.SaveDir + "tmpMusic/" + string + ".tmp";
                    Path path = Paths.get(string3, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        this.Mp3 = new Mp3Player(new File(string3));
                    } else {
                        try {
                            path = Paths.get(this.Gm.SaveDir + "tmpMusic/", new String[0]);
                            if (!Files.exists(path, new LinkOption[0])) {
                                Files.createDirectory(path, new FileAttribute[0]);
                            }
                            byte[] byArray = this.decryptData(file);
                            this.Gm.fileByteWrite(string3, byArray);
                            File file2 = new File(string3);
                            file2.setWritable(false, false);
                            this.Mp3 = new Mp3Player(file2);
                        }
                        catch (Exception exception) {
                            this.Mp3 = new Mp3Player();
                        }
                    }
                } else {
                    this.Mp3 = new Mp3Player(file);
                }
                this.Mp3.play();
                this.setBgmVolume(this.Gm.BgmVolume);
                this.Bgm2SetVolumeCount = 0;
                this.Bgm2Play = true;
            } else {
                this.bgmStop();
            }
        }
    }

    private byte[] decryptData(File file) {
        byte[] byArray = null;
        try {
            byte[] byArray2 = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray2);
            fileInputStream.close();
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, this.Gm.getDesKey());
            byArray = cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    public void run() {
        while (this.ThreadStart) {
            Object object;
            if (!this.SeStart.equals("")) {
                if (this.SeAcFlag) {
                    if (this.SeNow.get(this.SeStart).booleanValue()) {
                        this.Se.get(this.SeStart).stop();
                        this.SeNow.put(this.SeStart, false);
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else if (this.SeClip.get(this.SeStart).isRunning()) {
                    this.SeClip.get(this.SeStart).stop();
                    this.SeClip.get(this.SeStart).flush();
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.SeAcFlag) {
                    this.SeNow.put(this.SeStart, true);
                    this.Se.get(this.SeStart).play();
                } else {
                    double d = (double)this.Gm.SeVolume / 100.0;
                    object = (FloatControl)this.SeClip.get(this.SeStart).getControl(FloatControl.Type.MASTER_GAIN);
                    ((FloatControl)object).setValue((float)Math.log10(d) * 20.0f);
                    this.SeClip.get(this.SeStart).start();
                }
                this.SeStart = "";
            }
            if (this.Bgm2Play && this.Mp3 != null) {
                if (this.Bgm2SetVolumeCount < 5) {
                    this.setBgmVolume(this.Gm.BgmVolume);
                    ++this.Bgm2SetVolumeCount;
                }
                if (this.Mp3.getStatus() == 2) {
                    this.Mp3.play();
                    this.setBgmVolume(this.Gm.BgmVolume);
                    this.Bgm2SetVolumeCount = 0;
                }
            }
            if (this.MidiPlay) {
                long l;
                if (this.Midi != null) {
                    if (this.Midi.isOpen() && !this.Midi.isRunning()) {
                        if (this.MusicFirst) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.MusicFirst = false;
                        } else {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (this.Midi.isOpen() && !this.Midi.isRunning()) {
                            this.Midi.setTickPosition(0L);
                        }
                        if (this.Midi.isOpen() && !this.Midi.isRunning()) {
                            this.Midi.start();
                        }
                    }
                } else if (!this.MidiAcHashFlag && this.MusicFirst) {
                    String string = this.Bgm.get(this.BgmNow);
                    File file = new File(string);
                    object = string.substring(string.lastIndexOf(".") + 1);
                    try {
                        if (((String)object).equals("midDat")) {
                            byte[] byArray = this.decryptData(file);
                            String string2 = this.Gm.SaveDir + "music.tmp";
                            FileOutputStream fileOutputStream = new FileOutputStream(string2);
                            fileOutputStream.write(byArray);
                            fileOutputStream.close();
                            File file2 = new File(string2);
                            file2.setWritable(false, false);
                            this.MidiAc = Applet.newAudioClip(file2.toURI().toURL());
                            file2.delete();
                        } else {
                            this.MidiAc = Applet.newAudioClip(file.toURI().toURL());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.Gm.OS_NAME.indexOf("Linux") > -1 && this.Gm.VM_NAME.indexOf("Java HotSpot") > -1) {
                        this.MidiAc.loop();
                    } else {
                        this.MidiTime = System.currentTimeMillis();
                        this.MidiLength = this.MidiSequence.get(this.BgmNow).getMicrosecondLength() / 1000L;
                        this.MidiAc.play();
                    }
                    this.MusicFirst = false;
                } else if (this.MidiTime > 0L && (l = System.currentTimeMillis()) - this.MidiTime > this.MidiLength + 100L) {
                    this.MidiTime = l;
                    if (this.MidiAcHashFlag) {
                        this.MidiAcHash.get(this.BgmNow).stop();
                        this.MidiAcHash.get(this.BgmNow).play();
                    } else {
                        this.MidiAc.stop();
                        this.MidiAc.play();
                    }
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void bgmStop() {
        this.BgmNow = "";
        if (this.MidiPlay) {
            this.midiStop();
        }
        if (this.Bgm2Play) {
            this.mp3Stop();
        }
    }

    public void seSet(String string, String string2) {
        StringBuffer stringBuffer;
        int n;
        File file = null;
        Boolean bl = false;
        String string3 = "mp3,MP3,mp3Dat";
        String[] stringArray = string3.split(",");
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer = new StringBuffer(this.Gm.DIR_PATH + "sound/");
            stringBuffer.append(string2);
            stringBuffer.append(".");
            stringBuffer.append(stringArray[n]);
            string3 = stringBuffer.toString();
            file = new File(string3);
            if (!file.exists()) continue;
            this.SeHashMp3.put(string, file);
            bl = true;
            break;
        }
        if (!bl.booleanValue()) {
            string3 = "wav,WAV,wavDat";
            stringArray = string3.split(",");
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                stringBuffer = new StringBuffer(this.Gm.DIR_PATH + "sound/");
                stringBuffer.append(string2);
                stringBuffer.append(".");
                stringBuffer.append(stringArray[n]);
                string3 = stringBuffer.toString();
                file = new File(string3);
                if (!file.exists()) continue;
                String string4 = string3.substring(string3.lastIndexOf(".") + 1);
                if (this.SeAcFlag) {
                    try {
                        if (string4.equals("wavDat")) {
                            byte[] byArray = this.decryptData(file);
                            String string5 = this.Gm.SaveDir + "sound.tmp";
                            FileOutputStream fileOutputStream = new FileOutputStream(string5);
                            fileOutputStream.write(byArray);
                            fileOutputStream.close();
                            File file2 = new File(string5);
                            file2.setWritable(false, false);
                            this.Se.put(string, Applet.newAudioClip(file2.toURI().toURL()));
                            file2.delete();
                        } else {
                            this.Se.put(string, Applet.newAudioClip(file.toURI().toURL()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.SeNow.put(string, false);
                    break;
                }
                try {
                    AudioInputStream audioInputStream;
                    Object object;
                    Object object2;
                    if (string4.equals("wavDat")) {
                        object2 = this.decryptData(file);
                        object = new ByteArrayInputStream((byte[])object2);
                        audioInputStream = AudioSystem.getAudioInputStream((InputStream)object);
                        ((ByteArrayInputStream)object).close();
                    } else {
                        audioInputStream = AudioSystem.getAudioInputStream(file);
                    }
                    object2 = audioInputStream.getFormat();
                    object = new DataLine.Info(Clip.class, (AudioFormat)object2);
                    Clip clip = (Clip)AudioSystem.getLine((Line.Info)object);
                    clip.addLineListener(this);
                    clip.open(audioInputStream);
                    this.SeClip.put(string, clip);
                    audioInputStream.close();
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    public void sePlay(String string) {
        if (string.equals("") || string.equals("none")) {
            return;
        }
        if (this.SePlay) {
            if (this.SeHashMp3.containsKey(string)) {
                File file;
                String string2;
                String string3;
                if (this.SeMp3.size() > 2) {
                    this.SeMp3.get(0).stop();
                    this.SeMp3.remove(0);
                }
                if ((string3 = (string2 = (file = this.SeHashMp3.get(string)).getName()).substring(string2.lastIndexOf(".") + 1)).equals("mp3Dat")) {
                    String string4 = this.Gm.SaveDir + "tmpSound/" + string + ".tmp";
                    Path path = Paths.get(string4, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        this.SeMp3.add(new Mp3Player(new File(string4)));
                    } else {
                        try {
                            path = Paths.get(this.Gm.SaveDir + "tmpSound/", new String[0]);
                            if (!Files.exists(path, new LinkOption[0])) {
                                Files.createDirectory(path, new FileAttribute[0]);
                            }
                            byte[] byArray = this.decryptData(file);
                            this.Gm.fileByteWrite(string4, byArray);
                            File file2 = new File(string4);
                            file2.setWritable(false, false);
                            this.SeMp3.add(new Mp3Player(file2));
                        }
                        catch (Exception exception) {
                            this.SeMp3.add(new Mp3Player());
                        }
                    }
                } else {
                    this.SeMp3.add(new Mp3Player(file));
                }
                this.SeMp3.get(this.SeMp3.size() - 1).play();
                this.setSeVolume(this.Gm.SeVolume);
            } else if (this.SeAcFlag) {
                if (this.Se.containsKey(string)) {
                    this.SeStart = string;
                }
            } else if (this.SeClip.containsKey(string)) {
                this.SeStart = string;
            }
        }
    }

    public void seStop() {
        while (this.SeMp3.size() > 0) {
            this.SeMp3.get(0).stop();
            this.SeMp3.remove(0);
        }
        if (this.SeAcFlag) {
            for (String string : this.Se.keySet()) {
                this.Se.get(string).stop();
                this.SeNow.put(string, false);
            }
        } else {
            for (String string : this.SeClip.keySet()) {
                this.SeClip.get(string).stop();
                this.SeClip.get(string).flush();
            }
        }
        this.SeStart = "";
    }

    public void setBgmVolume(int n) {
        if (this.Bgm2Play && this.Mp3 != null) {
            double d = (double)n / 100.0;
            this.Mp3.setGain(d);
        }
    }

    public void setSeVolume(int n) {
        if (this.SeMp3.size() > 0) {
            double d = (double)n / 100.0;
            for (int i = 0; i < this.SeMp3.size(); ++i) {
                this.SeMp3.get(i).setGain(d);
            }
        }
    }

    @Override
    public void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP) {
            Clip clip = (Clip)lineEvent.getSource();
            clip.stop();
            clip.setFramePosition(0);
        }
    }

    private void midiStop() {
        this.MidiPlay = false;
        if (this.MidiAcFlag) {
            if (this.MidiAcHashFlag) {
                for (String string : this.MidiAcHash.keySet()) {
                    this.MidiAcHash.get(string).stop();
                }
                this.MidiTime = 0L;
            } else if (this.MidiAc != null) {
                this.MidiAc.stop();
                this.MidiTime = 0L;
                this.MusicFirst = false;
            }
        } else if (this.Midi != null && this.Midi.isOpen()) {
            this.Midi.stop();
            this.Midi.close();
            this.MusicFirst = false;
        }
    }

    private void mp3Stop() {
        this.Bgm2Play = false;
        this.Mp3.stop();
        this.Mp3 = null;
    }
}

