/*
 * Decompiled with CFR 0.152.
 */
package classFile;

import classFile.GameMode;
import classFile.MainPanel;
import classFile.MouseButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;

public class GameFrame
extends JFrame
implements WindowListener,
ComponentListener,
ItemListener,
ActionListener,
MouseListener,
KeyListener {
    public final MainPanel MP;
    public final JTextField TXT;
    public final MouseButton ButtonReset;
    public final MouseButton ButtonUp;
    public final MouseButton ButtonDown;
    public final MouseButton ButtonRight;
    public final MouseButton ButtonLeft;
    public final MouseButton ButtonSubMenu;
    public final MouseButton ButtonShiftRight;
    public final MouseButton ButtonShiftLeft;
    public final MouseButton ButtonEnter;
    public final MouseButton ButtonCancel;
    public final MouseButton ButtonMap;
    public final MouseButton ButtonStatus;
    public final MouseButton ButtonHoldDown;
    private JPopupMenu Popup;
    private GraphicsDevice Device = null;
    public JCheckBoxMenuItem MenuDebugWindow;
    public JCheckBoxMenuItem MenuGamepad;
    public JCheckBoxMenuItem MenuMouseOnColor;
    public JCheckBoxMenuItem MenuMouseRuledLine;
    public boolean DebugView = false;
    public int MarginX;
    public int MarginY;
    private GameMode Gm;
    private int SizeNow;
    private boolean OptionFlag = false;
    private SpringLayout Layout = new SpringLayout();
    private int TargetNum;
    private int TextMemoryNum = -1;
    private JCheckBoxMenuItem G_Normal;
    private JCheckBoxMenuItem G_HighReso;
    private ArrayList<String> TextMemory = new ArrayList();

    GameFrame(GameMode gameMode, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        int[] nArray;
        this.Gm = gameMode;
        this.SizeNow = n;
        this.setDefaultCloseOperation(3);
        this.setBackground(Color.black);
        this.setTitle(string);
        ImageIcon imageIcon = new ImageIcon(this.Gm.DIR_PATH + "graphic/icon.gif");
        this.setIconImage(imageIcon.getImage());
        this.addComponentListener(this);
        this.addWindowListener(this);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Option");
        jMenu.setMnemonic(79);
        JMenu jMenu2 = new JMenu("Size");
        jMenu2.setMnemonic(83);
        String string2 = "300, 450, 600, 800";
        if (!this.Gm.SizeList.equals("")) {
            string2 = this.Gm.SizeList;
        }
        string2 = string2.replaceAll("[ \u3000]", "");
        String[] stringArray = (string2 = this.Gm.zenkakuToHankaku(string2)).split(",");
        if (stringArray.length == 0) {
            nArray = new int[]{300};
        } else {
            nArray = new int[stringArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (stringArray[n3].matches("[0-9]+")) {
                    nArray[n3] = Integer.parseInt(stringArray[n3]);
                    if (nArray[n3] >= 300) continue;
                    nArray[n3] = 300;
                    continue;
                }
                nArray[n3] = 300;
            }
        }
        JMenuItem[] jMenuItemArray = new JMenuItem[nArray.length + 1];
        jMenuItemArray[0] = new JMenuItem("Adjust");
        jMenuItemArray[0].setMnemonic(65);
        jMenuItemArray[0].addActionListener(this);
        jMenuItemArray[0].setActionCommand("adjust");
        for (n3 = 0; n3 < nArray.length; ++n3) {
            jMenuItemArray[n3 + 1] = new JMenuItem(String.valueOf(nArray[n3]) + "*" + String.valueOf(nArray[n3]));
            jMenuItemArray[n3 + 1].addActionListener(this);
            jMenuItemArray[n3 + 1].setActionCommand(String.valueOf(nArray[n3]));
        }
        for (n3 = 0; n3 < jMenuItemArray.length; ++n3) {
            jMenu2.add(jMenuItemArray[n3]);
        }
        JMenu jMenu3 = new JMenu("Render");
        jMenu3.setMnemonic(82);
        this.G_Normal = new JCheckBoxMenuItem("Graphic: Normal");
        this.G_Normal.setMnemonic(78);
        this.G_Normal.addItemListener(this);
        this.G_HighReso = new JCheckBoxMenuItem("Graphic: High-Reso");
        this.G_HighReso.setMnemonic(72);
        this.G_HighReso.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Dungeon: Wire Frame");
        jCheckBoxMenuItem.setMnemonic(87);
        jCheckBoxMenuItem.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Dungeon: Graphic");
        jCheckBoxMenuItem2.setMnemonic(71);
        jCheckBoxMenuItem2.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Dungeon: Graphic High-Reso");
        jCheckBoxMenuItem3.setMnemonic(82);
        jCheckBoxMenuItem3.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Dungeon graphic: Perspective view");
        jCheckBoxMenuItem4.setMnemonic(80);
        jCheckBoxMenuItem4.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("AntiAlias");
        jCheckBoxMenuItem5.setMnemonic(65);
        jCheckBoxMenuItem5.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem6 = new JCheckBoxMenuItem("TextAntiAlias");
        jCheckBoxMenuItem6.setMnemonic(84);
        jCheckBoxMenuItem6.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem7 = new JCheckBoxMenuItem("Render: Quality");
        jCheckBoxMenuItem7.setMnemonic(81);
        jCheckBoxMenuItem7.addItemListener(this);
        JCheckBoxMenuItem jCheckBoxMenuItem8 = new JCheckBoxMenuItem("Render: Speed");
        jCheckBoxMenuItem8.setMnemonic(83);
        jCheckBoxMenuItem8.addItemListener(this);
        String string3 = this.Gm.getValueStr("cg");
        this.G_Normal.setSelected(false);
        this.G_HighReso.setSelected(false);
        if (string3.equals("normal")) {
            this.G_Normal.setSelected(true);
        } else if (string3.equals("highReso")) {
            this.G_HighReso.setSelected(true);
        }
        if (this.Gm.getValue("dungeonImg") == 0) {
            jCheckBoxMenuItem.setSelected(true);
        } else if (this.Gm.getValue("dungeonImg") == 2) {
            jCheckBoxMenuItem3.setSelected(true);
        } else {
            jCheckBoxMenuItem2.setSelected(true);
        }
        if (this.Gm.PerspectiveView) {
            jCheckBoxMenuItem4.setSelected(true);
        } else {
            jCheckBoxMenuItem4.setSelected(false);
        }
        if (bl) {
            jCheckBoxMenuItem5.setSelected(true);
        } else {
            jCheckBoxMenuItem5.setSelected(false);
        }
        if (bl2) {
            jCheckBoxMenuItem6.setSelected(true);
        } else {
            jCheckBoxMenuItem6.setSelected(false);
        }
        if (bl3) {
            jCheckBoxMenuItem7.setSelected(true);
        } else {
            jCheckBoxMenuItem8.setSelected(true);
        }
        jMenu3.add(this.G_Normal);
        jMenu3.add(this.G_HighReso);
        jMenu3.addSeparator();
        jMenu3.add(jCheckBoxMenuItem);
        jMenu3.add(jCheckBoxMenuItem2);
        jMenu3.add(jCheckBoxMenuItem3);
        jMenu3.addSeparator();
        jMenu3.add(jCheckBoxMenuItem4);
        jMenu3.addSeparator();
        jMenu3.add(jCheckBoxMenuItem5);
        jMenu3.addSeparator();
        jMenu3.add(jCheckBoxMenuItem6);
        jMenu3.addSeparator();
        jMenu3.add(jCheckBoxMenuItem7);
        jMenu3.add(jCheckBoxMenuItem8);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jCheckBoxMenuItem);
        buttonGroup.add(jCheckBoxMenuItem2);
        buttonGroup.add(jCheckBoxMenuItem3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jCheckBoxMenuItem7);
        buttonGroup2.add(jCheckBoxMenuItem8);
        JMenu jMenu4 = new JMenu("Sound");
        jMenu4.setMnemonic(68);
        JCheckBoxMenuItem jCheckBoxMenuItem9 = new JCheckBoxMenuItem("Bgm");
        jCheckBoxMenuItem9.setMnemonic(66);
        jCheckBoxMenuItem9.addItemListener(this);
        JMenu jMenu5 = new JMenu("Bgm Volume");
        int n4 = 20;
        int n5 = 100;
        JRadioButtonMenuItem[] jRadioButtonMenuItemArray = new JRadioButtonMenuItem[n4];
        ButtonGroup buttonGroup3 = new ButtonGroup();
        int n6 = n5;
        int n7 = n6 / n4;
        for (n3 = 0; n3 < n4; ++n3) {
            jRadioButtonMenuItemArray[n3] = new JRadioButtonMenuItem(String.valueOf(n6));
            jRadioButtonMenuItemArray[n3].setActionCommand("BgmVolume:" + String.valueOf(n6));
            jRadioButtonMenuItemArray[n3].addActionListener(this);
            buttonGroup3.add(jRadioButtonMenuItemArray[n3]);
            n6 -= n7;
        }
        int n8 = n4 - this.Gm.BgmVolume / 5;
        jRadioButtonMenuItemArray[n8].setSelected(true);
        JCheckBoxMenuItem jCheckBoxMenuItem10 = new JCheckBoxMenuItem("Se");
        jCheckBoxMenuItem10.setMnemonic(83);
        jCheckBoxMenuItem10.addItemListener(this);
        JMenu jMenu6 = new JMenu("Se Volume");
        JRadioButtonMenuItem[] jRadioButtonMenuItemArray2 = new JRadioButtonMenuItem[n4];
        ButtonGroup buttonGroup4 = new ButtonGroup();
        n6 = n5;
        for (n3 = 0; n3 < n4; ++n3) {
            jRadioButtonMenuItemArray2[n3] = new JRadioButtonMenuItem(String.valueOf(n6));
            jRadioButtonMenuItemArray2[n3].setActionCommand("SeVolume:" + String.valueOf(n6));
            jRadioButtonMenuItemArray2[n3].addActionListener(this);
            buttonGroup4.add(jRadioButtonMenuItemArray2[n3]);
            n6 -= n7;
        }
        n8 = n4 - this.Gm.SeVolume / 5;
        jRadioButtonMenuItemArray2[n8].setSelected(true);
        if (this.Gm.Bgm) {
            jCheckBoxMenuItem9.setSelected(true);
        } else {
            jCheckBoxMenuItem9.setSelected(false);
        }
        if (this.Gm.Se) {
            jCheckBoxMenuItem10.setSelected(true);
        } else {
            jCheckBoxMenuItem10.setSelected(false);
        }
        jMenu4.add(jCheckBoxMenuItem9);
        for (n3 = 0; n3 < n4; ++n3) {
            jMenu5.add(jRadioButtonMenuItemArray[n3]);
        }
        jMenu4.add(jMenu5);
        jMenu4.addSeparator();
        jMenu4.add(jCheckBoxMenuItem10);
        for (n3 = 0; n3 < n4; ++n3) {
            jMenu6.add(jRadioButtonMenuItemArray2[n3]);
        }
        jMenu4.add(jMenu6);
        JMenu jMenu7 = new JMenu("Operation");
        jMenu7.setMnemonic(79);
        JMenuItem jMenuItem = new JMenuItem("Key Config");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("keyConfig");
        this.MenuGamepad = new JCheckBoxMenuItem("Gamepad");
        this.MenuGamepad.setMnemonic(71);
        this.MenuGamepad.addItemListener(this);
        if (this.Gm.Gamepad) {
            this.MenuGamepad.setSelected(true);
        } else {
            this.MenuGamepad.setSelected(false);
        }
        if (this.Gm.JOYSTICK != null) {
            if (!this.Gm.JOYSTICK.foundGamepad()) {
                this.MenuGamepad.setEnabled(false);
            }
        } else {
            this.MenuGamepad.setEnabled(false);
        }
        JCheckBoxMenuItem jCheckBoxMenuItem11 = new JCheckBoxMenuItem("Mouse");
        jCheckBoxMenuItem11.setMnemonic(77);
        jCheckBoxMenuItem11.addItemListener(this);
        if (this.Gm.MouseOperation) {
            jCheckBoxMenuItem11.setSelected(true);
        } else {
            jCheckBoxMenuItem11.setSelected(false);
        }
        this.MenuMouseOnColor = new JCheckBoxMenuItem("Mouse: on color");
        this.MenuMouseOnColor.setMnemonic(79);
        this.MenuMouseOnColor.addItemListener(this);
        if (this.Gm.MouseOnColor) {
            this.MenuMouseOnColor.setSelected(true);
        } else {
            this.MenuMouseOnColor.setSelected(false);
        }
        if (!this.Gm.MouseOperation) {
            this.MenuMouseOnColor.setEnabled(false);
        }
        this.MenuMouseRuledLine = new JCheckBoxMenuItem("Mouse: ruled line");
        this.MenuMouseRuledLine.setMnemonic(82);
        this.MenuMouseRuledLine.addItemListener(this);
        if (this.Gm.MouseRuledLine) {
            this.MenuMouseRuledLine.setSelected(true);
        } else {
            this.MenuMouseRuledLine.setSelected(false);
        }
        if (!this.Gm.MouseOperation) {
            this.MenuMouseRuledLine.setEnabled(false);
        }
        jMenu7.add(jMenuItem);
        jMenu7.addSeparator();
        jMenu7.add(this.MenuGamepad);
        jMenu7.addSeparator();
        jMenu7.add(jCheckBoxMenuItem11);
        jMenu7.add(this.MenuMouseOnColor);
        jMenu7.add(this.MenuMouseRuledLine);
        JCheckBoxMenuItem jCheckBoxMenuItem12 = new JCheckBoxMenuItem("Key test");
        jCheckBoxMenuItem12.setMnemonic(75);
        jCheckBoxMenuItem12.addItemListener(this);
        this.MenuDebugWindow = new JCheckBoxMenuItem("Debug Window");
        this.MenuDebugWindow.addItemListener(this);
        StringBuilder stringBuilder = new StringBuilder().append(" ");
        this.Gm.getClass();
        JMenuItem jMenuItem2 = new JMenuItem(stringBuilder.append("v1.080").toString());
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("version");
        jMenu.add(jMenu2);
        jMenu.add(jMenu3);
        jMenu.add(jMenu4);
        jMenu.add(jMenu7);
        jMenu.add(jCheckBoxMenuItem12);
        jMenu.add(this.MenuDebugWindow);
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.Popup = new JPopupMenu();
        this.Popup.add(new DefaultEditorKit.CutAction());
        this.Popup.add(new DefaultEditorKit.CopyAction());
        this.Popup.add(new DefaultEditorKit.PasteAction());
        Container container = this.getContentPane();
        container.setBackground(Color.black);
        container.setLayout(new BorderLayout());
        this.MP = new MainPanel(this.Gm, bl, bl2, bl3);
        this.MP.setBackground(Color.black);
        this.TXT = new JTextField(40);
        this.TXT.setForeground(Color.black);
        this.TXT.setBackground(Color.white);
        this.TXT.setEnabled(false);
        this.TXT.setVisible(false);
        this.TextMemoryNum = -1;
        this.TXT.addKeyListener(this);
        this.TXT.addActionListener(this.MP);
        this.TXT.addMouseListener(this);
        this.TXT.setName("textField");
        this.MP.add(this.TXT);
        this.ButtonHoldDown = new MouseButton(this.Gm, "HoldDown", new Color(0, 0, 255, 60));
        this.MP.add(this.ButtonHoldDown);
        this.ButtonReset = new MouseButton(this.Gm, "Reset", new Color(255, 0, 0, 60));
        this.MP.add(this.ButtonReset);
        this.ButtonUp = new MouseButton(this.Gm, "Up", new Color(0, 255, 0, 60));
        this.MP.add(this.ButtonUp);
        this.ButtonDown = new MouseButton(this.Gm, "Down", new Color(0, 255, 0, 60));
        this.MP.add(this.ButtonDown);
        this.ButtonRight = new MouseButton(this.Gm, "Right", new Color(0, 255, 0, 60));
        this.MP.add(this.ButtonRight);
        this.ButtonLeft = new MouseButton(this.Gm, "Left", new Color(0, 255, 0, 60));
        this.MP.add(this.ButtonLeft);
        this.ButtonShiftRight = new MouseButton(this.Gm, "ShiftRight", new Color(255, 255, 0, 60));
        this.MP.add(this.ButtonShiftRight);
        this.ButtonShiftLeft = new MouseButton(this.Gm, "ShiftLeft", new Color(255, 255, 0, 60));
        this.MP.add(this.ButtonShiftLeft);
        this.ButtonEnter = new MouseButton(this.Gm, "Enter", new Color(255, 255, 0, 60));
        this.MP.add(this.ButtonEnter);
        this.ButtonCancel = new MouseButton(this.Gm, "Cancel", new Color(255, 255, 0, 60));
        this.MP.add(this.ButtonCancel);
        this.ButtonSubMenu = new MouseButton(this.Gm, "SubMenu", new Color(255, 255, 0, 60));
        this.MP.add(this.ButtonSubMenu);
        this.ButtonMap = new MouseButton(this.Gm, "Map", new Color(0, 0, 255, 60));
        this.MP.add(this.ButtonMap);
        this.ButtonStatus = new MouseButton(this.Gm, "Status", new Color(0, 0, 255, 60));
        this.MP.add(this.ButtonStatus);
        this.MP.setLayout(this.Layout);
        this.setMouseOperation(this.Gm.MouseOperation);
        container.add((Component)this.MP, "Center");
        this.setLocationByPlatform(true);
        this.setVisible(true);
        Insets insets = this.getInsets();
        this.MarginX = insets.left + insets.right;
        this.MarginY = insets.top + insets.bottom + this.getJMenuBar().getHeight();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < 300 + this.MarginX || dimension.height < 300 + this.MarginY) {
            n = this.SizeNow = 300;
            n2 = this.SizeNow;
        } else if (n + this.MarginX > dimension.width || n2 + this.MarginY > dimension.height) {
            this.SizeNow = dimension.height <= dimension.width ? dimension.height - this.MarginY : dimension.width - this.MarginX;
            n = this.SizeNow;
            n2 = this.SizeNow;
        }
        this.setSize(n + this.MarginX, n2 + this.MarginY);
        this.OptionFlag = true;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.Gm.Maximize = this.getExtendedState() == 6;
        Dimension dimension = this.MP.getSize();
        this.SizeNow = dimension.width <= dimension.height ? dimension.width : dimension.height;
        if (!this.Gm.Maximize) {
            this.Gm.Size = this.SizeNow;
        }
        this.configSaved();
        this.MP.changeFontSize();
        this.setFontTextField(this.SizeNow);
        this.MP.paintRepaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.gameExit();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.MP.repaint();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void gameExit() {
        int n;
        Object object;
        Object object2;
        this.Gm.SOUND.bgmStop();
        this.Gm.SOUND.seStop();
        this.configSaved();
        File file = new File(this.Gm.ErrorDir + "error.txt");
        if (file.exists() && file.length() > 0L) {
            boolean bl = true;
            object2 = this.Gm.textFileRead(this.Gm.ErrorDir + "error.txt");
            object = "";
            File file2 = new File(this.Gm.ErrorDir + "error.log");
            if (file2.exists() && ((String)(object = this.Gm.textFileRead(this.Gm.ErrorDir + "error.log"))).indexOf((String)object2) > -1) {
                bl = false;
            }
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!((String)object).equals("")) {
                    stringBuffer.append(this.Gm.BR);
                    stringBuffer.append(this.Gm.BR);
                    stringBuffer.append((String)object);
                }
                stringBuffer.insert(0, this.Gm.BR);
                stringBuffer.insert(0, (String)object2);
                stringBuffer.insert(0, this.Gm.BR);
                Comparable<File> comparable = new Date();
                SimpleDateFormat serializable = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                StringBuilder stringBuilder = new StringBuilder().append("[").append(serializable.format((Date)comparable)).append(" ");
                this.Gm.getClass();
                stringBuffer.insert(0, stringBuilder.append("v1.080").append("]").toString());
                if (stringBuffer.length() > 100000) {
                    stringBuffer.delete(100000, stringBuffer.length());
                }
                this.Gm.textFileWrite(this.Gm.ErrorDir + "error.log", stringBuffer.toString());
            }
        }
        File file3 = new File(this.Gm.SaveDir);
        object2 = file3.listFiles();
        for (Comparable<File> comparable : object2) {
            if (!comparable.isFile() || !comparable.toString().matches(".+\\.tmp")) continue;
            comparable.delete();
        }
        object = Paths.get(this.Gm.SaveDir + "tmpMusic/", new String[0]);
        if (Files.exists((Path)object, new LinkOption[0])) {
            file3 = new File(this.Gm.SaveDir + "tmpMusic/");
            for (File file2 : object2 = file3.listFiles()) {
                for (n = 0; n < 100 && !file2.delete(); ++n) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                Files.delete((Path)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Files.exists((Path)(object = Paths.get(this.Gm.SaveDir + "tmpSound/", new String[0])), new LinkOption[0])) {
            file3 = new File(this.Gm.SaveDir + "tmpSound/");
            for (File file4 : object2 = file3.listFiles()) {
                for (n = 0; n < 100 && !file4.delete(); ++n) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                Files.delete((Path)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        String string = mouseEvent.getComponent().getName();
        if (string.equals("textField")) {
            this.showPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        String string = mouseEvent.getComponent().getName();
        if (string.equals("textField")) {
            this.showPopup(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        String string = mouseEvent.getComponent().getName();
        if (string.equals("textField")) {
            this.showPopup(mouseEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            String string = this.Gm.TOWN.modeGet();
            if (string.equals("createName")) {
                this.MP.clear("text");
                this.TXT.setText("");
                this.TXT.setEnabled(false);
                this.TXT.setVisible(false);
                this.TextMemoryNum = -1;
                this.TXT.validate();
                this.requestFocusInWindow();
                this.Gm.TOWN.selectAction("edgeOfTown," + this.Gm.TOWN.getValue("menuSel") + ",0,0");
                this.Gm.SOUND.sePlay("cancel");
            } else if (string.equals("trainingChangeName")) {
                this.MP.clear("text");
                this.TXT.setText("");
                this.TXT.setEnabled(false);
                this.TXT.setVisible(false);
                this.TextMemoryNum = -1;
                this.TXT.validate();
                this.requestFocusInWindow();
                this.Gm.TOWN.selectAction("training,3,0,0");
                this.Gm.SOUND.sePlay("cancel");
            } else if (this.Gm.getValueBoolean("debugCommand")) {
                this.TXT.setText("");
                this.TXT.setEnabled(false);
                this.TXT.setVisible(false);
                this.TextMemoryNum = -1;
                this.TXT.validate();
                this.requestFocusInWindow();
                this.Gm.setValueBoolean("debugCommand", false);
                int n2 = this.Gm.getActiveParty();
                if (n2 > -1 && this.Gm.PARTY[n2].getMemberNum() == 0) {
                    n2 = -1;
                }
                if (!this.MP.getValueStr("partyStatus").equals("") && n2 > 0) {
                    this.Gm.PARTY[n2].statusSet();
                }
                this.MP.paintRepaint();
            }
        } else if (n == 38) {
            ++this.TextMemoryNum;
            int n3 = this.TextMemory.size();
            if (this.TextMemoryNum >= n3) {
                this.TextMemoryNum = n3 - 1;
            }
            if (this.TextMemoryNum > -1) {
                int n4 = n3 - this.TextMemoryNum - 1;
                this.TXT.setText(this.TextMemory.get(n4));
            }
        } else if (n == 40) {
            int n5;
            if (this.TextMemoryNum > -1) {
                --this.TextMemoryNum;
            }
            if (this.TextMemoryNum >= (n5 = this.TextMemory.size())) {
                this.TextMemoryNum = n5 - 1;
            }
            if (this.TextMemoryNum == -1) {
                this.TXT.setText("");
            } else {
                int n6 = n5 - this.TextMemoryNum - 1;
                this.TXT.setText(this.TextMemory.get(n6));
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setTextMemory(String string) {
        String string2;
        if (string.equals("")) {
            return;
        }
        if (this.TextMemory.size() > 0 && string.equals(string2 = this.TextMemory.get(this.TextMemory.size() - 1))) {
            return;
        }
        this.TextMemory.add(string);
        while (this.TextMemory.size() > 100) {
            this.TextMemory.remove(0);
        }
    }

    public void clearTextMemory() {
        this.TextMemory.clear();
    }

    private String getTextMemory() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n = this.TextMemory.size() - 1; i >= 0; --i) {
            if (i < n) {
                stringBuffer.append(this.Gm.BR);
            }
            stringBuffer.append(this.TextMemory.get(i));
        }
        return stringBuffer.toString();
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.Popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.OptionFlag) {
            return;
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getItemSelectable();
        String string = jCheckBoxMenuItem.getText();
        if (string.equals("Bgm")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.Gm.Bgm = true;
                this.Gm.SOUND.offOnSet("bgm", true);
            } else {
                this.Gm.Bgm = false;
                this.Gm.SOUND.offOnSet("bgm", false);
            }
            this.configSaved();
        } else if (string.equals("Se")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.Gm.SOUND.offOnSet("se", true);
                this.Gm.Se = true;
            } else {
                this.Gm.SOUND.offOnSet("se", false);
                this.Gm.Se = false;
            }
            this.configSaved();
        } else if (string.equals("Key test")) {
            this.Gm.KeyTest = jCheckBoxMenuItem.isSelected();
            this.MP.setValueStr("keyTestText", "");
            this.Gm.FRAME.MP.paintRepaint();
        } else if (string.equals("Debug Window")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.Gm.D_FRAME.setLocation(0, 0);
                this.Gm.D_FRAME.setWindowSize();
                this.Gm.D_FRAME.setExtendedState(0);
                this.Gm.D_FRAME.setVisible(true);
                this.Gm.D_FRAME.getMargin();
                this.Gm.D_FRAME.setColumnsAndRows();
                this.toFront();
            } else {
                this.Gm.D_FRAME.setVisible(false);
            }
        } else if (string.equals("Mouse")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.setMouseOperation(true);
                this.Gm.MouseOperation = true;
                this.MenuMouseOnColor.setEnabled(true);
                this.MenuMouseRuledLine.setEnabled(true);
                this.MP.cursorSet("default");
                this.Gm.EH.setValueString("holdDown", "");
                this.Gm.EH.setValueLong("mouseCursorTime", -1L);
            } else {
                this.setMouseOperation(false);
                this.Gm.MouseOperation = false;
                this.setMouseOpaque(false);
                this.MenuMouseOnColor.setEnabled(false);
                this.MenuMouseRuledLine.setEnabled(false);
                this.MP.cursorSet("default");
                this.Gm.EH.setValueString("holdDown", "");
                this.Gm.EH.setValueLong("mouseCursorTime", System.currentTimeMillis());
            }
            this.configSaved();
            if (this.Gm.MouseRuledLine) {
                this.Gm.FRAME.MP.paintRepaint();
            }
        } else if (string.equals("Mouse: on color")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.Gm.MouseOnColor = true;
            } else {
                this.Gm.MouseOnColor = false;
                this.setMouseOpaque(false);
            }
            this.configSaved();
            this.Gm.FRAME.MP.paintRepaint();
        } else if (string.equals("Mouse: ruled line")) {
            this.Gm.MouseRuledLine = jCheckBoxMenuItem.isSelected();
            this.configSaved();
            this.Gm.FRAME.MP.paintRepaint();
        } else if (string.equals("Gamepad")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.Gm.Gamepad = true;
                if (this.Gm.JOYSTICK != null) {
                    this.Gm.JOYSTICK.Gamepad = true;
                }
            } else {
                this.Gm.Gamepad = false;
                if (this.Gm.JOYSTICK != null) {
                    this.Gm.JOYSTICK.Gamepad = false;
                }
            }
            this.configSaved();
        } else if (string.equals("Dungeon graphic: Perspective view")) {
            int n;
            this.Gm.PerspectiveView = jCheckBoxMenuItem.isSelected();
            if (this.Gm.modeGet().equals("dungeon") && this.Gm.getValue("dungeonImg") != 0 && (n = this.Gm.getActiveParty()) > -1) {
                this.MP.setDungeonImage("");
                this.MP.setDungeonImage(this.Gm.DUNGEON.getValueStr("dungeonImage", this.Gm.PARTY[n].getValue("floor")));
            }
            this.configSaved();
            if (this.Gm.modeGet().equals("dungeon") && this.Gm.getValue("dungeonImg") != 0) {
                this.MP.paintRepaint();
            }
        } else if (Pattern.matches("Dungeon.+", string)) {
            if (string.indexOf("Wire") > -1) {
                this.Gm.setValue("dungeonImg", 0);
                this.MP.setDungeonImage("");
            } else {
                int n;
                if (string.indexOf("High-Reso") > -1) {
                    this.Gm.setValue("dungeonImg", 2);
                } else {
                    this.Gm.setValue("dungeonImg", 1);
                }
                if (this.Gm.modeGet().equals("dungeon") && (n = this.Gm.getActiveParty()) > -1) {
                    this.MP.setDungeonImage(this.Gm.DUNGEON.getValueStr("dungeonImage", this.Gm.PARTY[n].getValue("floor")));
                }
            }
            this.configSaved();
            if (this.Gm.modeGet().equals("dungeon")) {
                this.MP.paintRepaint();
            }
        } else if (Pattern.matches("Graphic.+", string)) {
            if (jCheckBoxMenuItem.isSelected()) {
                if (string.substring(9).equals("Normal")) {
                    this.Gm.setValueStr("cg", "normal");
                    this.Gm.Cg = "normal";
                    this.G_HighReso.setSelected(false);
                } else {
                    this.Gm.setValueStr("cg", "highReso");
                    this.Gm.Cg = "highReso";
                    this.G_Normal.setSelected(false);
                }
                this.configSaved();
                String string2 = this.MP.getValueStr("readImageName");
                if (!string2.equals("")) {
                    this.MP.bgCgSet(string2);
                }
                if (!(string2 = this.MP.getValueStr("readEventImageName")).equals("")) {
                    this.MP.eventCgSet(string2, this.MP.getValue("eventCgW"));
                }
                if (!(string2 = this.MP.getValueStr("readFaceImageName")).equals("")) {
                    this.MP.faceCgSet(-1, string2);
                }
                if (!(string2 = this.MP.getValueStr("readStatusImageName")).equals("")) {
                    this.MP.statusCgSet(string2);
                }
                if (this.MP.getValueBoolean("viewCg")) {
                    for (int i = 0; i < 6; ++i) {
                        this.MP.cgSet(i, this.MP.getValueStr("readImageName", i), this.MP.getValue("cgX", i), this.MP.getValue("cgY", i), this.MP.getValue("cgXT", i), this.MP.getValue("cgYT", i), this.MP.getValueBoolean("cgTransparent", i));
                    }
                }
            } else if (!this.G_Normal.isSelected() && !this.G_HighReso.isSelected()) {
                this.Gm.setValueStr("cg", "");
                this.configSaved();
                String string3 = this.MP.getValueStr("readImageName");
                if (!string3.equals("")) {
                    this.MP.clearReadBgImage();
                }
                if (!(string3 = this.MP.getValueStr("readEventImageName")).equals("")) {
                    this.MP.clearReadEventImage();
                }
                if (!(string3 = this.MP.getValueStr("readFaceImageName")).equals("")) {
                    this.MP.clearReadFaceImage();
                }
                if (!(string3 = this.MP.getValueStr("readStatusImageName")).equals("")) {
                    this.MP.clearReadStatusImage();
                }
                if (this.MP.getValueBoolean("viewCg")) {
                    this.MP.cgImageClear();
                }
            }
            this.MP.paintRepaint();
        } else if (string.equals("AntiAlias")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.MP.aliasSet(true);
                this.Gm.Alias = true;
            } else {
                this.MP.aliasSet(false);
                this.Gm.Alias = false;
            }
            this.configSaved();
            this.MP.paintRepaint();
        } else if (string.equals("TextAntiAlias")) {
            if (jCheckBoxMenuItem.isSelected()) {
                this.MP.textAliasSet(true);
                this.Gm.TextAlias = true;
            } else {
                this.MP.textAliasSet(false);
                this.Gm.TextAlias = false;
            }
            this.configSaved();
            this.MP.paintRepaint();
        } else if (Pattern.matches("Render.+", string)) {
            if (string.substring(8).equals("Quality")) {
                this.MP.renderSet(true);
                this.Gm.Render = true;
            } else {
                this.MP.renderSet(false);
                this.Gm.Render = false;
            }
            this.configSaved();
            this.MP.paintRepaint();
        }
    }

    private void setMouseOperation(boolean bl) {
        this.ButtonHoldDown.setVisible(bl);
        this.ButtonReset.setVisible(bl);
        this.ButtonUp.setVisible(bl);
        this.ButtonDown.setVisible(bl);
        this.ButtonRight.setVisible(bl);
        this.ButtonLeft.setVisible(bl);
        this.ButtonShiftRight.setVisible(bl);
        this.ButtonShiftLeft.setVisible(bl);
        this.ButtonEnter.setVisible(bl);
        this.ButtonCancel.setVisible(bl);
        this.ButtonSubMenu.setVisible(bl);
        this.ButtonMap.setVisible(bl);
        this.ButtonStatus.setVisible(bl);
    }

    private void setMouseOpaque(boolean bl) {
        this.ButtonHoldDown.setOpaque(bl);
        this.ButtonReset.setOpaque(bl);
        this.ButtonUp.setOpaque(bl);
        this.ButtonDown.setOpaque(bl);
        this.ButtonRight.setOpaque(bl);
        this.ButtonLeft.setOpaque(bl);
        this.ButtonShiftRight.setOpaque(bl);
        this.ButtonShiftLeft.setOpaque(bl);
        this.ButtonEnter.setOpaque(bl);
        this.ButtonCancel.setOpaque(bl);
        this.ButtonSubMenu.setOpaque(bl);
        this.ButtonMap.setOpaque(bl);
        this.ButtonStatus.setOpaque(bl);
    }

    public void configSaved() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Size = ");
        stringBuffer.append(String.valueOf(this.Gm.Size));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Bgm = ");
        stringBuffer.append(String.valueOf(this.Gm.Bgm));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("BgmVolume = ");
        stringBuffer.append(String.valueOf(this.Gm.BgmVolume));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Se = ");
        stringBuffer.append(String.valueOf(this.Gm.Se));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("SeVolume = ");
        stringBuffer.append(String.valueOf(this.Gm.SeVolume));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Alias = ");
        stringBuffer.append(String.valueOf(this.Gm.Alias));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("TextAlias = ");
        stringBuffer.append(String.valueOf(this.Gm.TextAlias));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Render = ");
        if (this.Gm.Render) {
            stringBuffer.append("quality");
        } else {
            stringBuffer.append("speed");
        }
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Cg = ");
        if (this.Gm.Cg.equals("")) {
            stringBuffer.append("none");
        } else {
            stringBuffer.append(this.Gm.Cg);
        }
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Dungeon = ");
        if (this.Gm.getValue("dungeonImg") == 0) {
            stringBuffer.append("wireFrame");
        } else if (this.Gm.getValue("dungeonImg") == 1) {
            stringBuffer.append("graphic");
        } else {
            stringBuffer.append("graphicHighReso");
        }
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("PerspectiveView = ");
        stringBuffer.append(String.valueOf(this.Gm.PerspectiveView));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Gamepad = ");
        stringBuffer.append(String.valueOf(this.Gm.Gamepad));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("Mouse = ");
        stringBuffer.append(String.valueOf(this.Gm.MouseOperation));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("MouseOnColor = ");
        stringBuffer.append(String.valueOf(this.Gm.MouseOnColor));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("MouseRuledLine = ");
        stringBuffer.append(String.valueOf(this.Gm.MouseRuledLine));
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append("TextMemory = ");
        stringBuffer.append(this.Gm.BR);
        stringBuffer.append(this.getTextMemory());
        this.Gm.textFileWrite(this.Gm.ConfigDir + "config.ini", stringBuffer.toString());
    }

    public void setFontTextField(int n) {
        Font font;
        if (this.Gm.FONT_NAME.indexOf(".ttf") > -1 || this.Gm.FONT_NAME.indexOf(".TTF") > -1) {
            try {
                font = Font.createFont(0, this.MP.FontFile).deriveFont(0, this.MP.getValue("fontSize"));
            }
            catch (Exception exception) {
                font = new Font(this.Gm.FONT_NAME, 0, this.MP.getValue("fontSize"));
            }
        } else {
            font = new Font(this.Gm.FONT_NAME, 0, this.MP.getValue("fontSize"));
        }
        this.TXT.setFont(font);
        Dimension dimension = this.MP.getSize();
        this.Layout.putConstraint("West", (Component)this.TXT, (dimension.width - n) / 2 + (n / 2 - this.TXT.getPreferredSize().width / 2), "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.TXT, (dimension.height - n) / 2 + 80 * n / 300, "North", (Component)this.MP);
        this.ButtonHoldDown.setPreferredSize(new Dimension(100 * n / 300, 20 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonHoldDown, (dimension.width - n) / 2, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonHoldDown, (dimension.height - n) / 2, "North", (Component)this.MP);
        this.ButtonReset.setPreferredSize(new Dimension(50 * n / 300, 20 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonReset, (dimension.width - n) / 2 + (n - this.ButtonReset.getPreferredSize().width), "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonReset, (dimension.height - n) / 2, "North", (Component)this.MP);
        this.ButtonShiftLeft.setPreferredSize(new Dimension(100 * n / 300, 80 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonShiftLeft, (dimension.width - n) / 2, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonShiftLeft, (dimension.height - n) / 2 + 20 * n / 300, "North", (Component)this.MP);
        this.ButtonUp.setPreferredSize(new Dimension(100 * n / 300, 100 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonUp, (dimension.width - n) / 2 + 100 * n / 300, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonUp, (dimension.height - n) / 2, "North", (Component)this.MP);
        this.ButtonShiftRight.setPreferredSize(new Dimension(100 * n / 300, 80 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonShiftRight, (dimension.width - n) / 2 + 200 * n / 300, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonShiftRight, (dimension.height - n) / 2 + 20 * n / 300, "North", (Component)this.MP);
        this.ButtonLeft.setPreferredSize(new Dimension(100 * n / 300, 100 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonLeft, (dimension.width - n) / 2, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonLeft, (dimension.height - n) / 2 + 100 * n / 300, "North", (Component)this.MP);
        this.ButtonEnter.setPreferredSize(new Dimension(100 * n / 300, 100 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonEnter, (dimension.width - n) / 2 + 100 * n / 300, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonEnter, (dimension.height - n) / 2 + 100 * n / 300, "North", (Component)this.MP);
        this.ButtonRight.setPreferredSize(new Dimension(100 * n / 300, 100 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonRight, (dimension.width - n) / 2 + 200 * n / 300, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonRight, (dimension.height - n) / 2 + 100 * n / 300, "North", (Component)this.MP);
        this.ButtonCancel.setPreferredSize(new Dimension(100 * n / 300, 70 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonCancel, (dimension.width - n) / 2, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonCancel, (dimension.height - n) / 2 + 200 * n / 300, "North", (Component)this.MP);
        this.ButtonDown.setPreferredSize(new Dimension(100 * n / 300, 100 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonDown, (dimension.width - n) / 2 + 100 * n / 300, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonDown, (dimension.height - n) / 2 + 200 * n / 300, "North", (Component)this.MP);
        this.ButtonSubMenu.setPreferredSize(new Dimension(100 * n / 300, 70 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonSubMenu, (dimension.width - n) / 2 + 200 * n / 300, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonSubMenu, (dimension.height - n) / 2 + 200 * n / 300, "North", (Component)this.MP);
        this.ButtonMap.setPreferredSize(new Dimension(100 * n / 300, 30 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonMap, (dimension.width - n) / 2 + 200 * n / 300, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonMap, (dimension.height - n) / 2 + 270 * n / 300, "North", (Component)this.MP);
        this.ButtonStatus.setPreferredSize(new Dimension(100 * n / 300, 30 * n / 300));
        this.Layout.putConstraint("West", (Component)this.ButtonStatus, (dimension.width - n) / 2, "West", (Component)this.MP);
        this.Layout.putConstraint("North", (Component)this.ButtonStatus, (dimension.height - n) / 2 + 270 * n / 300, "North", (Component)this.MP);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("version")) {
            if (string.matches("BgmVolume:[0-9]+")) {
                String string2 = string.replace("BgmVolume:", "");
                this.Gm.BgmVolume = Integer.parseInt(string2);
                this.Gm.SOUND.setBgmVolume(this.Gm.BgmVolume);
            } else if (string.matches("SeVolume:[0-9]+")) {
                String string3 = string.replace("SeVolume:", "");
                this.Gm.SeVolume = Integer.parseInt(string3);
                this.Gm.SOUND.setSeVolume(this.Gm.SeVolume);
            } else if (string.equals("keyConfig")) {
                StringBuffer stringBuffer = new StringBuffer("<html><body>");
                String[] stringArray = new String[]{"UP", "DOWN", "RIGHT", "LEFT", "SHIFT", "SHIFT_RIGHT", "SHIFT_LEFT", "ENTER", "CANCEL", "STATUS", "SUBMENU", "MAP", "RESET", "DEBUG"};
                for (int i = 0; i < stringArray.length && (this.Gm.DEBUG || i < stringArray.length - 1); ++i) {
                    if (i > 0) {
                        stringBuffer.append("<br>");
                    }
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(" = \"");
                    stringBuffer.append(this.Gm.KEY_CONFIG[i]);
                    stringBuffer.append("\"");
                }
                stringBuffer.append("</body></html>");
                JLabel jLabel = new JLabel(stringBuffer.toString());
                jLabel.setFont(this.MP.GameFont);
                JOptionPane.showMessageDialog(this, jLabel, "Key Config", -1);
            } else if (string.equals("adjust")) {
                if (!this.Gm.Maximize) {
                    this.setVisible(false);
                    this.setSize(this.SizeNow + this.MarginX, this.SizeNow + this.MarginY);
                    this.setVisible(true);
                    this.MP.changeFontSize();
                    this.setFontTextField(this.SizeNow);
                    this.MP.paintRepaint();
                }
            } else if (string.matches("[0-9]+")) {
                this.Gm.Size = this.SizeNow = Integer.parseInt(string);
                this.Gm.Maximize = false;
                this.configSaved();
                this.setVisible(false);
                this.setSize(this.SizeNow + this.MarginX, this.SizeNow + this.MarginY);
                this.setVisible(true);
                this.MP.changeFontSize();
                this.setFontTextField(this.SizeNow);
                this.MP.paintRepaint();
            }
        }
    }

    public void setTargetNum(int n) {
        this.TargetNum = n;
    }

    public int getTargetNum() {
        return this.TargetNum;
    }

    public void setValue(String string, int n) {
        if (string.equals("sizeNow")) {
            this.SizeNow = n;
        } else if (string.equals("textMemoryNum")) {
            this.TextMemoryNum = n;
        }
    }

    public int getValue(String string) {
        if (string.equals("sizeNow")) {
            return this.SizeNow;
        }
        if (string.equals("marginX")) {
            return this.MarginX;
        }
        if (string.equals("marginY")) {
            return this.MarginY;
        }
        if (string.equals("targetNum")) {
            return this.TargetNum;
        }
        return 0;
    }

    public void reset() {
        this.TextMemoryNum = -1;
    }
}

