/*
 * Decompiled with CFR 0.152.
 */
package classFile;

import classFile.GameMode;
import classFile.MonsterDataModel;
import java.util.ArrayList;

public class MonsterModel {
    private GameMode Gm;
    public final int MONSTER_NUM;
    private boolean[] GetHeal;
    private boolean[] Resist;
    private boolean[] Resist0;
    private boolean[] WeakPoint;
    private boolean[] WeakPoint0;
    private boolean[] AttackAdd;
    private boolean[] AttackAddPlus;
    private byte[] ResistPlus;
    private int Hp;
    private int HpMax;
    private int HpMax0;
    private int[][] Mp;
    private int[][] MpMax;
    private int Level;
    private int Ac;
    private int[] Ability;
    private int AtPoison;
    private int PoisonPlus;
    private int Asleep;
    private int Silence;
    private int[] Action;
    private int SpellCancel;
    private int Poison;
    private int State;
    private int At;
    private int At0;
    private int Hit;
    private int HitPlus;
    private int AcPlus;
    private int ScPlus;
    private int SrPlus;
    private int BrPlus;
    private int AtCountPlus;
    private int SetMonster;
    private int[] AbiPlus;
    private int NoBreath;
    private int HealPlus;
    private int BreathBarrier;
    private int AddDmgPlus;
    private int TmpHp;
    private int TmpHpTurn;
    private int AtCountTurn;
    private int AcTurn;
    private int HitTurn;
    private int ScTurn;
    private int SrTurn;
    private int BrTurn;
    private int HealTurn;
    private int BrBaTurn;
    private int[] AbiTurn;
    private int AddDmgTurn;
    private int[] ResistTurn;
    private int[] AttackAddTurn;
    private int Hate;
    private int HateTurn;
    private long Exp;
    private String[] Name;
    private String[] Names;
    private ArrayList<Integer> CD_Attribute;
    private ArrayList<Integer> CD_Turn;
    private ArrayList<String> CD_Value;
    private ArrayList<String> CD_Resist;
    private int Ac0;
    private int[] Ability0;
    private int SpellCancel0;
    private int Hit0;

    MonsterModel(GameMode gameMode, int n) {
        this.Gm = gameMode;
        this.MONSTER_NUM = n;
        this.AbiPlus = new int[this.Gm.ABILITY.length];
        this.AbiTurn = new int[this.Gm.ABILITY.length];
        this.ResistPlus = new byte[14];
        this.ResistTurn = new int[14];
        this.AttackAddPlus = new boolean[6];
        this.AttackAddTurn = new int[6];
        this.clear();
    }

    public void clear() {
        int n;
        this.Name = new String[2];
        this.Name[0] = "";
        this.Name[1] = "";
        this.Names = new String[2];
        this.Names[0] = "";
        this.Names[1] = "";
        this.Level = 1;
        this.Ac = 10;
        this.HpMax0 = 0;
        this.HpMax = 0;
        this.Hp = -1;
        this.Mp = new int[this.Gm.SPELL_KIND + 1][this.Gm.SPELL_LVMAX];
        this.MpMax = new int[this.Gm.SPELL_KIND + 1][this.Gm.SPELL_LVMAX];
        for (n = 0; n < this.Gm.SPELL_KIND + 1; ++n) {
            for (int i = 0; i < this.Gm.SPELL_LVMAX; ++i) {
                this.Mp[n][i] = 0;
                this.MpMax[n][i] = 0;
            }
        }
        this.Asleep = 0;
        this.Silence = 0;
        this.NoBreath = 0;
        this.Poison = 0;
        this.State = 0;
        this.Ability = new int[this.Gm.ABILITY.length];
        this.Ability0 = new int[this.Gm.ABILITY.length];
        int n2 = this.Gm.ABILITY.length;
        for (n = 0; n < n2; ++n) {
            this.Ability0[n] = 1;
        }
        this.Hit = 0;
        this.HitPlus = 0;
        this.SpellCancel = 0;
        this.AcPlus = 0;
        this.ScPlus = 0;
        this.SrPlus = 0;
        this.BrPlus = 0;
        this.HealPlus = 0;
        this.BreathBarrier = 0;
        this.TmpHp = 0;
        this.AtCountPlus = 0;
        this.Hate = -1;
        this.AcTurn = -1;
        this.HitTurn = -1;
        this.ScTurn = -1;
        this.SrTurn = -1;
        this.BrTurn = -1;
        this.HateTurn = -1;
        this.HealTurn = -1;
        this.BrBaTurn = -1;
        this.AddDmgTurn = -1;
        this.TmpHpTurn = -1;
        this.AtCountTurn = -1;
        for (n = 0; n < this.AbiPlus.length; ++n) {
            this.AbiPlus[n] = 0;
            this.AbiTurn[n] = -1;
        }
        for (n = 0; n < this.ResistPlus.length; ++n) {
            this.ResistPlus[n] = -2;
            this.ResistTurn[n] = -1;
        }
        for (n = 0; n < this.AttackAddPlus.length; ++n) {
            this.AttackAddPlus[n] = false;
            this.AttackAddTurn[n] = -1;
        }
        this.PoisonPlus = 0;
        this.Action = new int[3];
        n2 = this.Action.length;
        for (n = 0; n < n2; ++n) {
            this.Action[n] = -1;
        }
        this.SetMonster = -1;
        this.GetHeal = new boolean[8];
        for (n = 0; n < 8; ++n) {
            this.GetHeal[n] = false;
        }
        this.Exp = 0L;
        this.CD_Attribute = new ArrayList();
        this.CD_Turn = new ArrayList();
        this.CD_Value = new ArrayList();
        this.CD_Resist = new ArrayList();
        this.Resist = new boolean[13];
        this.Resist0 = new boolean[13];
        this.WeakPoint = new boolean[13];
        this.WeakPoint0 = new boolean[13];
        n2 = this.Resist.length;
        for (n = 0; n < n2; ++n) {
            this.Resist[n] = false;
            this.Resist0[n] = false;
            this.WeakPoint[n] = false;
            this.WeakPoint0[n] = false;
        }
        this.AttackAdd = new boolean[5];
        n2 = this.AttackAdd.length;
        for (n = 0; n < n2; ++n) {
            this.AttackAdd[n] = false;
        }
        this.AtPoison = 0;
    }

    public void create(int n, int n2) {
        int n3;
        MonsterDataModel[] monsterDataModelArray = this.Gm.MONSTER_DATA;
        this.SetMonster = n;
        this.Name[0] = monsterDataModelArray[n].NAME[0];
        this.Name[1] = monsterDataModelArray[n].NAME[1];
        this.Names[0] = monsterDataModelArray[n].NAMES[0];
        this.Names[1] = monsterDataModelArray[n].NAMES[1];
        String[] stringArray = this.Gm.DUNGEON.getValueStr("boxTrap", this.Gm.DUNGEON.getValue("dFloor")).split("<>");
        int n4 = Integer.parseInt(stringArray[0]);
        String string = this.Gm.replaceStr(monsterDataModelArray[n].LEVEL, "trap\\.lv", String.valueOf(n4));
        this.Level = (int)this.Gm.strCalculation(string);
        if (this.Level < 1) {
            this.Level = 1;
        } else if (this.Level > 99999) {
            this.Level = 99999;
        }
        int n5 = this.Gm.ABILITY.length;
        for (n3 = 0; n3 < n5; ++n3) {
            this.Ability0[n3] = monsterDataModelArray[n].ABILITY[n3];
            this.Ability[n3] = this.Ability0[n3];
        }
        string = this.Gm.replaceStr(monsterDataModelArray[n].HP_MAX, "monster\\.lv", String.valueOf(this.Level));
        string = this.Gm.replaceStr(string, "trap\\.lv", String.valueOf(n4));
        string = this.replaceMonsterType(string);
        string = this.replaceMonsterAbi0(string);
        this.HpMax0 = (int)this.Gm.strCalculation(string);
        if (this.HpMax0 < 1) {
            this.HpMax0 = 1;
        } else if (this.HpMax0 > 999999999) {
            this.HpMax0 = 999999999;
        }
        this.Hp = this.HpMax = this.HpMax0;
        string = this.Gm.replaceStr(monsterDataModelArray[n].MP_MAX, "monster\\.lv", String.valueOf(this.Level));
        string = this.Gm.replaceStr(string, "trap\\.lv", String.valueOf(n4));
        string = this.replaceMonsterType(string);
        string = this.replaceMonsterAbi0(string);
        int n6 = (int)this.Gm.strCalculation(string);
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 > 99) {
            n6 = 99;
        }
        for (n3 = 0; n3 < this.Gm.SPELL_KIND + 1; ++n3) {
            for (int i = 0; i < this.Gm.SPELL_LVMAX; ++i) {
                this.MpMax[n3][i] = n6;
                this.Mp[n3][i] = this.MpMax[n3][i];
            }
        }
        string = this.Gm.replaceStr(monsterDataModelArray[n].EXP, "monster\\.lv", String.valueOf(this.Level));
        string = this.Gm.replaceStr(string, "trap\\.lv", String.valueOf(n4));
        string = this.replaceMonsterType(string);
        string = this.replaceMonsterAbi0(string);
        this.Exp = (long)this.Gm.strCalculation(string);
        if (this.Exp < 0L) {
            this.Exp = 0L;
        } else if (this.Exp > 999999999999L) {
            this.Exp = 999999999999L;
        }
        this.Asleep = 0;
        this.Silence = n2;
        this.Poison = 0;
        this.State = 0;
        this.SpellCancel = this.SpellCancel0 = monsterDataModelArray[n].SPELL_CANCEL;
        n5 = this.Resist0.length;
        for (n3 = 0; n3 < n5; ++n3) {
            this.Resist0[n3] = monsterDataModelArray[n].RESIST.indexOf(Integer.toHexString(n3)) > -1;
            this.WeakPoint0[n3] = monsterDataModelArray[n].WEAK_POINT.indexOf(Integer.toHexString(n3)) > -1;
        }
        this.check();
        string = this.Gm.replaceStr(monsterDataModelArray[n].AC, "monster\\.ac", "0");
        this.Ac0 = this.Gm.monsterCalculation(string, this.MONSTER_NUM);
        if (this.Ac0 < -99) {
            this.Ac0 = -99;
        } else if (this.Ac0 > 999) {
            this.Ac0 = 999;
        }
        this.Ac = this.Ac0;
        this.HitPlus = 0;
        this.AcPlus = 0;
        this.ScPlus = 0;
        this.SrPlus = 0;
        this.BrPlus = 0;
        this.HealPlus = 0;
        this.AddDmgPlus = 0;
        this.TmpHp = 0;
        this.AtCountPlus = 0;
        this.Hate = -1;
        this.AcTurn = -1;
        this.HitTurn = -1;
        this.ScTurn = -1;
        this.SrTurn = -1;
        this.BrTurn = -1;
        this.AtCountTurn = -1;
        this.HealTurn = -1;
        this.BrBaTurn = -1;
        this.AddDmgTurn = -1;
        this.TmpHpTurn = -1;
        this.HateTurn = -1;
        for (n3 = 0; n3 < this.AbiPlus.length; ++n3) {
            this.AbiPlus[n3] = 0;
            this.AbiTurn[n3] = -1;
        }
        this.BreathBarrier = 0;
        this.CD_Attribute = new ArrayList();
        this.CD_Turn = new ArrayList();
        this.CD_Value = new ArrayList();
        this.CD_Resist = new ArrayList();
        for (n3 = 0; n3 < 8; ++n3) {
            this.GetHeal[n3] = false;
        }
        n5 = this.Action.length;
        for (n3 = 0; n3 < n5; ++n3) {
            this.Action[n3] = -1;
        }
    }

    private String replaceMonsterType(String string) {
        if (string.indexOf("monster.Type") > -1) {
            StringBuffer stringBuffer = new StringBuffer("monster\\.Type\\[");
            stringBuffer.append(String.valueOf(this.Gm.MONSTER_DATA[this.SetMonster].TYPE));
            stringBuffer.append("\\]");
            string = this.Gm.replaceStr(string, stringBuffer.toString(), "1");
            stringBuffer = new StringBuffer("monster\\.Type\\[[0-9]+\\]");
            string = this.Gm.replaceStr(string, stringBuffer.toString(), "0");
        }
        return string;
    }

    private String replaceMonsterAbi0(String string) {
        if (string.indexOf("monster.abi0") > -1) {
            StringBuffer stringBuffer;
            int n = this.Gm.ABILITY.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer = new StringBuffer("monster\\.abi0\\[");
                stringBuffer.append(String.valueOf(i));
                stringBuffer.append("\\]");
                string = this.Gm.replaceStr(string, stringBuffer.toString(), String.valueOf(this.Ability0[i]));
            }
            stringBuffer = new StringBuffer("monster\\.abi0\\[[0-9]+\\]");
            string = this.Gm.replaceStr(string, stringBuffer.toString(), "0");
        }
        return string;
    }

    public int raceCommentNum(String string) {
        int n = 0;
        string = this.Gm.zenkakuToHankaku(string);
        String string2 = this.Gm.deleteLineFeedCode(this.Gm.MONSTER_DATA[this.SetMonster].COMMENT);
        if ((string2 = this.Gm.zenkakuToHankaku(string2)).indexOf(string) > -1) {
            n = 1;
        }
        return n;
    }

    public void hpPlus(int n) {
        this.Hp += n;
        if (this.Hp > this.HpMax) {
            this.Hp = this.HpMax;
        } else if (this.Hp < 1) {
            this.Hp = 0;
        }
    }

    public boolean mpDamage(int n) {
        int n2;
        int n3;
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n < 0) {
            return bl;
        }
        for (n3 = 0; n3 < this.Gm.SPELL_KIND + 1; ++n3) {
            for (n2 = 0; n2 < this.Gm.SPELL_LVMAX; ++n2) {
                if (this.Mp[n3][n2] <= 0) continue;
                arrayList.add(n3 * 10 + n2);
            }
        }
        while (n > 0 && arrayList.size() > 0) {
            bl = true;
            int n4 = this.Gm.dice(1, arrayList.size()) - 1;
            int n5 = (Integer)arrayList.get(n4);
            n3 = (int)Math.floor(n5 / 10);
            n2 = n5 % 10;
            int[] nArray = this.Mp[n3];
            int n6 = n2;
            nArray[n6] = nArray[n6] - 1;
            if (this.Mp[n3][n2] < 1) {
                arrayList.remove(n4);
            }
            --n;
        }
        return bl;
    }

    public void healingEffect(boolean bl, int n) {
        int n2;
        String string;
        if (this.Asleep > 0) {
            if (bl) {
                string = this.Gm.CURE_ASLEEP_DMG;
                string = this.Gm.replaceStr(string, "damage", String.valueOf(n));
            } else {
                string = this.Gm.CURE_ASLEEP_TURN;
            }
            string = this.Gm.replaceStr(string, "my\\.", "monster.");
            n2 = this.Gm.monsterCalculation(string, this.MONSTER_NUM);
            if (bl) {
                if (n2 < 0) {
                    n2 = 0;
                }
            } else if (n2 < 1) {
                n2 = 1;
            }
            this.Asleep -= n2;
            if (this.Asleep < 0) {
                this.Asleep = 0;
            }
        }
        if (!bl) {
            string = this.Gm.replaceStr(this.Gm.CURE_SILENCE, "my\\.", "monster.");
            n2 = this.Gm.monsterCalculation(string, this.MONSTER_NUM);
            if (n2 < 1) {
                n2 = 1;
            }
            if (this.Silence > 0) {
                this.Silence -= n2;
                if (this.Silence < 0) {
                    this.Silence = 0;
                }
            }
            if (this.NoBreath > 0) {
                this.NoBreath -= n2;
                if (this.NoBreath < 0) {
                    this.NoBreath = 0;
                }
            }
        }
    }

    public boolean possibleToAction() {
        return this.Hp > 0 && this.Asleep == 0 && this.State < 2;
    }

    public boolean checkAttackAdd(int n) {
        if (n >= 0 && n <= 4) {
            return this.AttackAdd[n];
        }
        if (n == 5) {
            return this.AtPoison > 0;
        }
        if (n == 6) {
            return this.Gm.MONSTER_DATA[this.SetMonster].DRAIN > 0;
        }
        return false;
    }

    public void setValue(String string, int n) {
        if (string.equals("hp")) {
            this.Hp = n;
        } else if (string.equals("hpMax0")) {
            this.HpMax0 = n;
        } else if (string.equals("hpMax")) {
            this.HpMax = n;
        } else if (string.equals("level")) {
            this.Level = n;
        } else if (string.equals("state")) {
            this.State = n;
        } else if (string.equals("ac")) {
            this.Ac = n;
        } else if (string.equals("ac0") || string.equals("ac1")) {
            this.Ac0 = n;
        } else if (string.equals("hit")) {
            this.Hit = n;
        } else if (string.equals("hit0") || string.equals("hit1")) {
            this.Hit0 = n;
        } else if (string.equals("at")) {
            this.At = n;
        } else if (string.equals("at0")) {
            this.At0 = n;
        } else if (string.equals("hitPlus")) {
            this.HitPlus = n;
        } else if (string.equals("asleep")) {
            this.Asleep = n;
        } else if (string.equals("silence")) {
            this.Silence = n;
        } else if (string.equals("noBreath")) {
            this.NoBreath = n;
        } else if (string.equals("spellCancel") || string.equals("sc")) {
            this.SpellCancel = n;
        } else if (string.equals("sc0") || string.equals("sc1")) {
            this.SpellCancel0 = n;
        } else if (string.equals("hitPlus")) {
            this.HitPlus = n;
        } else if (string.equals("addDmgPlus")) {
            this.AddDmgPlus = n;
        } else if (string.equals("acPlus")) {
            this.AcPlus = n;
        } else if (string.equals("scPlus")) {
            this.ScPlus = n;
        } else if (string.equals("srPlus")) {
            this.SrPlus = n;
        } else if (string.equals("brPlus")) {
            this.BrPlus = n;
        } else if (string.equals("healPlus")) {
            this.HealPlus = n;
        } else if (string.equals("poison")) {
            this.Poison = n;
        } else if (string.equals("breathBarrier")) {
            this.BreathBarrier = n;
        } else if (string.equals("atCountPlus")) {
            this.AtCountPlus = n;
        } else if (string.equals("acTurn")) {
            this.AcTurn = n;
        } else if (string.equals("hitTurn")) {
            this.HitTurn = n;
        } else if (string.equals("scTurn")) {
            this.ScTurn = n;
        } else if (string.equals("srTurn")) {
            this.SrTurn = n;
        } else if (string.equals("brTurn")) {
            this.BrTurn = n;
        } else if (string.equals("healTurn")) {
            this.HealTurn = n;
        } else if (string.equals("brBaTurn")) {
            this.BrBaTurn = n;
        } else if (string.equals("addDmgTurn")) {
            this.AddDmgTurn = n;
        } else if (string.equals("tmpHp")) {
            this.TmpHp = n;
        } else if (string.equals("tmpHpTurn")) {
            this.TmpHpTurn = n;
        } else if (string.equals("atCountTurn")) {
            this.AtCountTurn = n;
        } else if (string.equals("poisonPlus")) {
            this.PoisonPlus = n;
        } else if (string.equals("hate")) {
            this.Hate = n;
        } else if (string.equals("hateTurn")) {
            this.HateTurn = n;
        }
    }

    public void setValue(String string, int n, int n2) {
        if (string.equals("ability")) {
            this.Ability[n] = n2;
        } else if (string.equals("ability0") || string.equals("ability1")) {
            this.Ability0[n] = n2;
        } else if (string.equals("action")) {
            this.Action[n] = n2;
        } else if (string.equals("abiPlus")) {
            this.AbiPlus[n] = n2;
        } else if (string.equals("resistPlus")) {
            this.ResistPlus[n] = (byte)n2;
        } else if (string.equals("resistTurn")) {
            this.ResistTurn[n] = n2;
        } else if (string.equals("attackAddTurn")) {
            this.AttackAddTurn[n] = n2;
        } else if (string.equals("cdAttribute")) {
            this.CD_Attribute.set(n, n2);
        } else if (string.equals("cdTurn")) {
            this.CD_Turn.set(n, n2);
        } else if (string.equals("abiTurn")) {
            this.AbiTurn[n] = n2;
        }
    }

    public void setValue(String string, int n, int n2, int n3) {
        if (string.equals("mp")) {
            this.Mp[n][n2] = n3;
        } else if (string.equals("mpMax")) {
            this.MpMax[n][n2] = n3;
        }
    }

    public void setValueBoolean(String string, int n, boolean bl) {
        if (string.equals("getHeal")) {
            this.GetHeal[n] = bl;
        } else if (string.equals("attackAddPlus")) {
            this.AttackAddPlus[n] = bl;
        }
    }

    public void setValueStr(String string, int n, String string2) {
        if (string.equals("name")) {
            this.Name[n] = string2;
        } else if (string.equals("names")) {
            this.Names[n] = string2;
        } else if (string.equals("cdValue")) {
            this.CD_Value.set(n, string2);
        } else if (string.equals("cdResist")) {
            this.CD_Resist.set(n, string2);
        }
    }

    public void addValue(String string, int n) {
        if (string.equals("cdAttribute")) {
            this.CD_Attribute.add(n);
        } else if (string.equals("cdTurn")) {
            this.CD_Turn.add(n);
        }
    }

    public void addValueStr(String string, String string2) {
        if (string.equals("cdValue")) {
            this.CD_Value.add(string2);
        } else if (string.equals("cdResist")) {
            this.CD_Resist.add(string2);
        }
    }

    public int getGroupNum() {
        int n;
        block6: {
            n = -1;
            if (!this.Gm.BATTLE.getValueBoolean("battleMode")) break block6;
            if (this.MONSTER_NUM < 50) {
                block0: for (int i = 0; i < 4 && n <= -1; ++i) {
                    for (int j = 0; j < 9; ++j) {
                        if (this.Gm.BATTLE.getValue("monster", i, j) != this.MONSTER_NUM) continue;
                        n = i;
                        continue block0;
                    }
                }
            } else {
                int n2 = this.MONSTER_NUM - 50;
                block2: for (int i = 0; i < 2 && n <= -1; ++i) {
                    for (int j = 0; j < 9; ++j) {
                        if (this.Gm.BATTLE.getValue("summon", i, j) != n2) continue;
                        n = i;
                        continue block2;
                    }
                }
            }
        }
        return n;
    }

    public int getGroupMember() {
        int n;
        block5: {
            n = 0;
            if (!this.Gm.BATTLE.getValueBoolean("battleMode")) break block5;
            int n2 = this.getGroupNum();
            if (n2 < 0) {
                return n;
            }
            if (this.MONSTER_NUM < 50) {
                for (int i = 0; i < 9; ++i) {
                    int n3 = this.Gm.BATTLE.getValue("monster", n2, i);
                    if (n3 != this.MONSTER_NUM) continue;
                    n = i;
                    break;
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    int n4 = this.Gm.BATTLE.getValue("summon", n2, i);
                    if (n4 != this.MONSTER_NUM - 50) continue;
                    n = i;
                    break;
                }
            }
        }
        return n;
    }

    public int getGroupMemberNum(boolean bl) {
        int n;
        block7: {
            n = 0;
            if (!this.Gm.BATTLE.getValueBoolean("battleMode")) break block7;
            int n2 = this.getGroupNum();
            if (n2 < 0) {
                return n;
            }
            if (this.MONSTER_NUM < 50) {
                for (int i = 0; i < 9; ++i) {
                    int n3 = this.Gm.BATTLE.getValue("monster", n2, i);
                    if (n3 <= -1) continue;
                    if (!bl) {
                        if (this.Gm.MONSTER[n3].getValue("hp") <= 0) continue;
                        ++n;
                        continue;
                    }
                    if (!this.Gm.MONSTER[n3].possibleToAction()) continue;
                    ++n;
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    int n4 = this.Gm.BATTLE.getValue("summon", n2, i);
                    if (n4 <= -1) continue;
                    if (!bl) {
                        if (this.Gm.SUMMON[n4].getValue("hp") <= 0) continue;
                        ++n;
                        continue;
                    }
                    if (!this.Gm.SUMMON[n4].possibleToAction()) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getValue(String string) {
        if (string.equals("hp")) {
            return this.Hp;
        }
        if (string.equals("hpMax0")) {
            return this.HpMax0;
        }
        if (string.equals("hpMax")) {
            return this.HpMax;
        }
        if (string.equals("level")) {
            return this.Level;
        }
        if (string.equals("state")) {
            return this.State;
        }
        if (string.equals("ac")) {
            int n = this.Ac;
            if (this.Gm.BATTLE.getValueBoolean("battleTurn")) {
                String string2;
                if (!this.possibleToAction() || this.Gm.BATTLE.getValueBoolean("ambush")) {
                    string2 = this.Gm.replaceStr(this.Gm.NON_MOVE_AC, "my\\.", "monster.");
                    string2 = this.Gm.replaceStr(string2, "monster\\.ac", String.valueOf(this.Ac));
                    n += this.Gm.monsterCalculation(string2, this.MONSTER_NUM);
                }
                if (this.possibleToAction() && this.Action[0] == 2) {
                    string2 = this.Gm.replaceStr(this.Gm.PARRY_AC, "my\\.", "monster.");
                    string2 = this.Gm.replaceStr(string2, "monster\\.ac", String.valueOf(this.Ac));
                    n += this.Gm.monsterCalculation(string2, this.MONSTER_NUM);
                }
                if (n < -99) {
                    n = -99;
                } else if (n > 999) {
                    n = 999;
                }
            }
            return n;
        }
        if (string.equals("ac0") || string.equals("ac1")) {
            return this.Ac0;
        }
        if (string.equals("hit")) {
            return this.Hit;
        }
        if (string.equals("hit0") || string.equals("hit1")) {
            return this.Hit0;
        }
        if (string.equals("at")) {
            return this.At;
        }
        if (string.equals("at0")) {
            return this.At0;
        }
        if (string.equals("asleep")) {
            return this.Asleep;
        }
        if (string.equals("silence")) {
            return this.Silence;
        }
        if (string.equals("noBreath")) {
            return this.NoBreath;
        }
        if (string.equals("spellCancel") || string.equals("sc")) {
            return this.SpellCancel;
        }
        if (string.equals("sc0") || string.equals("sc1")) {
            return this.SpellCancel0;
        }
        if (string.equals("hitPlus")) {
            return this.HitPlus;
        }
        if (string.equals("addDmgPlus")) {
            return this.AddDmgPlus;
        }
        if (string.equals("acPlus")) {
            return this.AcPlus;
        }
        if (string.equals("scPlus")) {
            return this.ScPlus;
        }
        if (string.equals("srPlus")) {
            return this.SrPlus;
        }
        if (string.equals("brPlus")) {
            return this.BrPlus;
        }
        if (string.equals("healPlus")) {
            return this.HealPlus;
        }
        if (string.equals("poison")) {
            return this.Poison;
        }
        if (string.equals("setMonster")) {
            return this.SetMonster;
        }
        if (string.equals("breathBarrier")) {
            return this.BreathBarrier;
        }
        if (string.equals("atCountPlus")) {
            return this.AtCountPlus;
        }
        if (string.equals("acTurn")) {
            return this.AcTurn;
        }
        if (string.equals("hitTurn")) {
            return this.HitTurn;
        }
        if (string.equals("scTurn")) {
            return this.ScTurn;
        }
        if (string.equals("srTurn")) {
            return this.SrTurn;
        }
        if (string.equals("brTurn")) {
            return this.BrTurn;
        }
        if (string.equals("healTurn")) {
            return this.HealTurn;
        }
        if (string.equals("brBaTurn")) {
            return this.BrBaTurn;
        }
        if (string.equals("addDmgTurn")) {
            return this.AddDmgTurn;
        }
        if (string.equals("tmpHp")) {
            return this.TmpHp;
        }
        if (string.equals("tmpHpTurn")) {
            return this.TmpHpTurn;
        }
        if (string.equals("atCountTurn")) {
            return this.AtCountTurn;
        }
        if (string.equals("atPoison")) {
            return this.AtPoison;
        }
        if (string.equals("poisonPlus")) {
            return this.PoisonPlus;
        }
        if (string.equals("hate")) {
            return this.Hate;
        }
        if (string.equals("hateTurn")) {
            return this.HateTurn;
        }
        return 0;
    }

    public int getValue(String string, int n) {
        if (string.equals("ability")) {
            return this.Ability[n];
        }
        if (string.equals("ability0") || string.equals("ability1")) {
            return this.Ability0[n];
        }
        if (string.equals("action")) {
            return this.Action[n];
        }
        if (string.equals("abiPlus")) {
            return this.AbiPlus[n];
        }
        if (string.equals("resistPlus")) {
            return this.ResistPlus[n];
        }
        if (string.equals("resistTurn")) {
            return this.ResistTurn[n];
        }
        if (string.equals("attackAddTurn")) {
            return this.AttackAddTurn[n];
        }
        if (string.equals("cdAttribute")) {
            return this.CD_Attribute.get(n);
        }
        if (string.equals("cdTurn")) {
            return this.CD_Turn.get(n);
        }
        if (string.equals("abiTurn")) {
            return this.AbiTurn[n];
        }
        return 0;
    }

    public int getValue(String string, int n, int n2) {
        if (string.equals("mp")) {
            return this.Mp[n][n2];
        }
        if (string.equals("mpMax")) {
            return this.MpMax[n][n2];
        }
        return 0;
    }

    public long getValueLong(String string) {
        if (string.equals("exp")) {
            return this.Exp;
        }
        return 0L;
    }

    public boolean getValueBoolean(String string, int n) {
        if (n < 0) {
            return false;
        }
        if (string.equals("getHeal")) {
            return this.GetHeal[n];
        }
        if (string.equals("resist")) {
            return this.Resist[n];
        }
        if (string.equals("resist0") || string.equals("resist1")) {
            return this.Resist0[n];
        }
        if (string.equals("weakPoint")) {
            return this.WeakPoint[n];
        }
        if (string.equals("weakPoint0") || string.equals("weakPoint1")) {
            return this.WeakPoint0[n];
        }
        if (string.equals("attackAdd")) {
            return this.AttackAdd[n];
        }
        if (string.equals("attackAddPlus")) {
            return this.AttackAddPlus[n];
        }
        return false;
    }

    public String getValueStr(String string, int n) {
        if (string.equals("name")) {
            return this.Name[n];
        }
        if (string.equals("names")) {
            return this.Names[n];
        }
        if (string.equals("cdValue")) {
            return this.CD_Value.get(n);
        }
        if (string.equals("cdResist")) {
            return this.CD_Resist.get(n);
        }
        return "";
    }

    public void removeValue(String string, int n) {
        if (string.equals("cdAttribute")) {
            this.CD_Attribute.remove(n);
        } else if (string.equals("cdTurn")) {
            this.CD_Turn.remove(n);
        } else if (string.equals("cdValue")) {
            this.CD_Value.remove(n);
        } else if (string.equals("cdResist")) {
            this.CD_Resist.remove(n);
        }
    }

    public void clearValue(String string) {
        if (string.equals("cdAttribute")) {
            this.CD_Attribute.clear();
        } else if (string.equals("cdTurn")) {
            this.CD_Turn.clear();
        } else if (string.equals("cdValue")) {
            this.CD_Value.clear();
        } else if (string.equals("cdResist")) {
            this.CD_Resist.clear();
        }
    }

    public int getLength(String string) {
        if (string.equals("cdAttribute")) {
            return this.CD_Attribute.size();
        }
        if (string.equals("cdTurn")) {
            return this.CD_Turn.size();
        }
        if (string.equals("cdValue")) {
            return this.CD_Value.size();
        }
        if (string.equals("cdResist")) {
            return this.CD_Resist.size();
        }
        if (string.equals("attackAdd")) {
            return this.AttackAdd.length;
        }
        return 0;
    }

    public void check() {
        int n;
        if (this.Name[0].equals("") && this.Name[1].equals("")) {
            return;
        }
        String string = this.Gm.replaceStr(this.Gm.HIT_MODIFY, "my\\.", "monster.");
        string = this.Gm.replaceStr(string, "monster\\.hit", "0");
        this.Hit0 = this.Gm.monsterCalculation(string, this.MONSTER_NUM);
        string = this.Gm.replaceStr(this.Gm.MONSTER_HIT_MODIFY, "monster\\.hit", "0");
        this.Hit0 += this.Gm.monsterCalculation(string, this.MONSTER_NUM);
        if (this.Hit0 < -999) {
            this.Hit0 = -999;
        } else if (this.Hit0 > 999) {
            this.Hit0 = 999;
        }
        this.Hit = this.Hit0 + this.HitPlus;
        if (this.Hit < -999) {
            this.Hit = -999;
        } else if (this.Hit > 999) {
            this.Hit = 999;
        }
        string = this.Gm.replaceStr(this.Gm.MONSTER_DATA[this.SetMonster].AT, "monster\\.at0", "0");
        string = this.Gm.replaceStr(string, "monster\\.at", "0");
        this.At0 = this.Gm.monsterCalculation(string, this.MONSTER_NUM);
        if (this.At0 < 1) {
            this.At0 = 1;
        } else if (this.At0 > 99) {
            this.At0 = 99;
        }
        this.At = this.At0 + this.AtCountPlus;
        if (this.At < 1) {
            this.At = 1;
        } else if (this.At > 99) {
            this.At = 99;
        }
        int n2 = this.Resist.length;
        for (n = 0; n < n2; ++n) {
            this.Resist[n] = this.Resist0[n];
            this.WeakPoint[n] = this.WeakPoint0[n];
        }
        n2 = this.ResistPlus.length;
        for (n = 0; n < n2; ++n) {
            int n3;
            if (n == 0) {
                n3 = 9;
            } else if (n == 1) {
                n3 = 0;
            } else if (n == 2) {
                n3 = 10;
            } else if (n == 3) {
                n3 = 11;
            } else if (n == 4) {
                n3 = 12;
            } else if (n == 6) {
                n3 = 1;
            } else if (n == 7) {
                n3 = 2;
            } else if (n == 8) {
                n3 = 3;
            } else if (n == 9) {
                n3 = 4;
            } else if (n == 10) {
                n3 = 5;
            } else if (n == 11) {
                n3 = 6;
            } else if (n == 12) {
                n3 = 7;
            } else {
                if (n != 13) continue;
                n3 = 8;
            }
            int n4 = this.getValue("resistPlus", n);
            if (n4 == 1) {
                this.Resist[n3] = true;
                this.WeakPoint[n3] = false;
                continue;
            }
            if (n4 == 0) {
                this.Resist[n3] = false;
                this.WeakPoint[n3] = false;
                continue;
            }
            if (n4 != -1) continue;
            this.Resist[n3] = false;
            this.WeakPoint[n3] = true;
        }
        n2 = this.AttackAdd.length;
        for (n = 0; n < n2; ++n) {
            this.AttackAdd[n] = this.Gm.MONSTER_DATA[this.SetMonster].ATTACK_ADD.indexOf(String.valueOf(n)) > -1;
        }
        this.AtPoison = this.Gm.MONSTER_DATA[this.SetMonster].POISON;
        n2 = this.AttackAddPlus.length;
        for (n = 0; n < n2; ++n) {
            if (!this.AttackAddPlus[n]) continue;
            if (n == n2 - 1) {
                this.AtPoison += this.PoisonPlus;
                continue;
            }
            this.AttackAdd[n] = true;
        }
        if (this.AtPoison > 99999) {
            this.AtPoison = 99999;
        } else if (this.AtPoison < 0) {
            this.AtPoison = 0;
        }
    }
}

