/*
 * Decompiled with CFR 0.152.
 */
package classFile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.EnumSet;
import javax.swing.border.Border;

public class PartialLineBorder
implements Border {
    private final EnumSet<Position> positions_;
    private final Color lineColor_;
    private final int thickness_;

    public PartialLineBorder(Position position, Color color, int n) {
        this(EnumSet.of(position), color, n);
    }

    public PartialLineBorder(EnumSet<Position> enumSet, Color color, int n) {
        this.positions_ = enumSet;
        this.lineColor_ = color;
        this.thickness_ = n;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor_);
        block6: for (Position position : this.positions_) {
            switch (position) {
                case OVER: {
                    int n5;
                    for (n5 = 0; n5 < this.thickness_; ++n5) {
                        graphics.drawLine(n, n2 + n5, n + n3, n2 + n5);
                    }
                    continue block6;
                }
                case UNDER: {
                    int n5;
                    for (n5 = 0; n5 < this.thickness_; ++n5) {
                        graphics.drawLine(n, n2 + n4 - n5 - 1, n + n3, n2 + n4 - n5 - 1);
                    }
                    continue block6;
                }
                case LEFT: {
                    int n5;
                    for (n5 = 0; n5 < this.thickness_; ++n5) {
                        graphics.drawLine(n + n5, n2, n + n5, n2 + n4 - 1);
                    }
                    continue block6;
                }
                case RIGHT: {
                    int n5;
                    for (n5 = 0; n5 < this.thickness_; ++n5) {
                        graphics.drawLine(n + n3 - n5 - 1, n2, n + n3 - n5 - 1, n2 + n4 - 1);
                    }
                    continue block6;
                }
            }
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = new Insets(0, 0, 0, 0);
        for (Position position : this.positions_) {
            switch (position) {
                case OVER: {
                    insets.top = this.thickness_;
                    break;
                }
                case UNDER: {
                    insets.bottom = this.thickness_;
                    break;
                }
                case LEFT: {
                    insets.left = this.thickness_;
                    break;
                }
                case RIGHT: {
                    insets.right = this.thickness_;
                    break;
                }
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static enum Position {
        OVER,
        UNDER,
        LEFT,
        RIGHT;

    }
}

