class MapPanel{constructor(fontSize){this.FontSize=fontSize;this.LineWidth=calTimes(this.FontSize,0.13);this.LineWidthHalf=calTimes(this.LineWidth,0.5);this.FontSizeHalf=fontSize/2;this.BaseSize=this.FontSizeHalf*3;let x=this.FontSizeHalf*4;let y=this.FontSizeHalf*2+this.BaseSize*20;this.BasePoint=[x,y];this.MapSize=0;this.MapRuleColor=DefaultMessage["_MAP_RULE_COLOR"];if(this.MapRuleColor.match(/^[0-9a-zA-Z][0-9a-zA-Z][0-9a-zA-Z][0-9a-zA-Z][0-9a-zA-Z][0-9a-zA-Z]$/)){this.MapRuleColor="#"+this.MapRuleColor;}this.Color=[];this.Color[0]="#b4b4b4";this.Color[1]="#969696";this.Color[2]="#c8c8c8";this.Color[3]="#da70d6";this.Color[4]="#9c8cff";this.MapWidth=20;this.MapHeight=20;this.WallFlag=[];for(let i=0;i<512;i++){this.WallFlag[i]=true;}this.clearMapData();}clearCanvas(id){let cv=document.getElementById(id);let ctx=cv.getContext("2d");ctx.clearRect(0,0,cv.width,cv.height);}clearMapData(type){type=checkNull(type,"");if(type.match(/^(|westWall|wall|map)$/)){this.WestWall=[];for(let i=0;i<20;i++){this.WestWall[i]=[];for(let j=0;j<20;j++){this.WestWall[i][j]="0";}}}if(type.match(/^(|southWall|wall|map)$/)){this.SouthWall=[];for(let i=0;i<20;i++){this.SouthWall[i]=[];for(let j=0;j<20;j++){this.SouthWall[i][j]="0";}}}if(type.match(/^(|space|map)$/)){this.Space=[];for(let i=0;i<20;i++){this.Space[i]=[];for(let j=0;j<20;j++){this.Space[i][j]="0";}}}if(type.match(/^(|monsterRoom|room)$/)){this.MonsterRoom=[];for(let i=0;i<20;i++){this.MonsterRoom[i]=[];for(let j=0;j<20;j++){this.MonsterRoom[i][j]=-1;}}}if(type.match(/^(|roomGuardian|room)$/)){this.RoomGuardian=[];for(let i=0;i<100;i++){this.RoomGuardian[i]="";}}if(type.match(/^(|mapping)$/)){this.Mapping=[];for(let i=0;i<20;i++){this.Mapping[i]=[];for(let j=0;j<20;j++){this.Mapping[i][j]=false;}}}}drawEllipse(id,cx,cy,w,h,lineWidth,lineColor,bgColor){let cv=document.getElementById(id);let ctx=cv.getContext("2d");if(lineWidth==undefined||lineWidth==null){lineWidth=1;}if(lineWidth>0&&lineWidth<1){lineWidth=1;}ctx.lineWidth=lineWidth;let pi2=Math.PI*2;let ratio=h/w;let radius=Math.max(w,h)/2;let increment=1/radius;ctx.beginPath();let x=cx+radius*Math.cos(0);let y=cy-ratio*radius*Math.sin(0);ctx.lineTo(x,y);for(let radians= increment;radians<pi2;radians+= increment){x=cx+radius*Math.cos(radians);y=cy-ratio*radius*Math.sin(radians);ctx.lineTo(x,y);}ctx.closePath();if(bgColor!=undefined&&bgColor!=null){ctx.fillStyle=bgColor;ctx.fill();}if(lineColor!=undefined&&lineColor!=null){ctx.strokeStyle=lineColor;ctx.stroke();}}drawLine(id,point,lineWidth,lineCap,lineJoin,lineColor,polygon,bgColor){let cv=document.getElementById(id);let ctx=cv.getContext("2d");if(point.length<2){ return;}if(lineWidth==undefined||lineWidth==null){lineWidth=1;}if(lineWidth>0&&lineWidth<1){lineWidth=1;}if(lineCap==undefined||lineCap==null){lineCap="round";}if(lineJoin ==undefined||lineJoin ==null){lineJoin ="miter";}if(lineColor==undefined||lineColor==null){lineColor="white";}if(polygon==undefined||polygon==null){polygon=false;}ctx.lineWidth=lineWidth;ctx.lineCap=lineCap;ctx.strokeStyle=lineColor;ctx.beginPath();ctx.moveTo(point[0][0],point[0][1]);for(let i=1;i<point.length;i++){ctx.lineTo(point[i][0],point[i][1]);}if(polygon&&point.length>2){ctx.closePath();if(bgColor!=undefined&&bgColor!=null){ctx.fillStyle=bgColor;ctx.fill();if(lineWidth>0){ctx.stroke();}} else {ctx.stroke();}} else {ctx.stroke();}}drawRect(id,x,y,w,h,lineWidth,fillColor,strokeColor){let cv=document.getElementById(id);let ctx=cv.getContext("2d");fillColor=checkNull(fillColor,"");strokeColor=checkNull(strokeColor,"");x=checkNull(x,0),y=checkNull(y,0);w=checkNull(w,calMinus(cv.width,x)),h=checkNull(h,calMinus(cv.height,y));lineWidth=checkNull(lineWidth,1);ctx.lineWidth=lineWidth;if(fillColor!=""){ctx.fillStyle=fillColor;ctx.fillRect(x,y,w,h);}if(strokeColor!=""){ctx.strokeStyle=strokeColor;ctx.strokeRect(x,y,w,h);}}drawText(id,x,y,text,color){let cv=document.getElementById(id);let ctx=cv.getContext("2d");x=checkNull(x,0),y=checkNull(y,0);color=checkNull(color,"white");ctx.fillStyle=color;ctx.fillText(text,x,y);}fillCanvas(id,fillColor){let cv=document.getElementById(id);fillColor=checkNull(fillColor,"black");let ctx=cv.getContext("2d");ctx.fillStyle=fillColor;ctx.fillRect(0,0,cv.width,cv.height);}getMousePoint(mX,mY,type){let result=[];let sX=mX-this.BasePoint[0];if(sX<0){sX=-1;}else {sX=Math.floor(calDiv(sX,this.BaseSize));}let sY=(this.MapSize-mY)-(this.MapSize-this.BasePoint[1]);if(sY<0){sY=-1;}else {sY=Math.floor(calDiv(sY,this.BaseSize));}if(type=="s"){result[0]=sX;result[1]=sY;result[2]="space";result[3]="";} else {let pX=mX-(this.BasePoint[0]-this.BaseSize);pX%=this.BaseSize;let pY=(this.MapSize-mY)-(this.MapSize-(this.BasePoint[1]+this.BaseSize));pY%=this.BaseSize;let area;result[2]="";if(type=="ws"){let x=[],y=[];let wallW=calDiv(this.BaseSize,5);x[0]=wallW;y[0]=this.BaseSize-wallW;x[1]=this.BaseSize-wallW;y[1]=wallW;if(pX>=x[0]&&pX<x[1]&&pY<y[0]&&pY>=y[1]){result[0]=sX;result[1]=sY;result[2]="space";result[3]="";}}if(result[2]==""){area=this.getMousePointArea(pX,pY);if(area==0){result[0]=sX;result[1]=sY;result[2]="south";result[3]="S";}else if(area==1){result[0]=sX;result[1]=sY;result[2]="west";result[3]="E";}else if(area==2){result[0]=sX;result[1]=sY+1;result[2]="south";result[3]="N";}else if(area==3){result[0]=sX+1;result[1]=sY;result[2]="west";result[3]="W";}}}return result;}getMousePointArea(x,y){let result=0,area="";let h=x*Math.tan(Math.PI/4);if(y<h){area="03";}else {area="12";}h=(this.BaseSize-x)*Math.tan(Math.PI/4);if(y<h){if(area=="03"){result=0;}else {result=1;}} else {if(area=="03"){result=3;}else {result=2;}}return result;}mapBase(id,sizeX,sizeY){this.clearCanvas(id);this.fillCanvas(id,"black");for(let i=0;i<sizeX+1;i++){this.mapRuledLine(id,i,sizeY-1,"w");}for(let i=0;i<sizeY+1;i++){this.mapRuledLine(id,sizeX-1,i,"s");}let fsh=this.FontSizeHalf;let fshh=calTimes(fsh,0.5);for(let i=0;i<sizeX;i++){let str=MF.strFitLength(String(i),2,"right");this.drawText(id,this.BasePoint[0]+fshh+(fsh*3)*i,this.BasePoint[1]+fsh,str,this.Color[0]);}for(let i=0;i<sizeY;i++){let str=MF.strFitLength(String(i),2,"right");this.drawText(id,this.BasePoint[0]-fsh*3,this.BasePoint[1]-(fsh*2+fshh)-(fsh*3)*i,str,this.Color[0]);}}mapRuledLine(id,nX,nY,ws){ws=checkNull(ws,"w");let start,end;if(ws.indexOf("w")>-1){start=[this.BasePoint[0]+this.BaseSize*nX,this.BasePoint[1]];end=[this.BasePoint[0]+this.BaseSize*nX,this.BasePoint[1]-this.BaseSize*(nY+1)];} else if(ws.indexOf("s")>-1){start=[this.BasePoint[0],this.BasePoint[1]-this.BaseSize*nY];end=[this.BasePoint[0]+this.BaseSize*(nX+1),this.BasePoint[1]-this.BaseSize*nY];}this.drawLine(id,[[start[0],start[1]],[end[0],end[1]]],this.LineWidth,"square","",this.MapRuleColor);}mapSpace(id,nX,nY,type){let cv=document.getElementById(id);let ctx=cv.getContext("2d");let bw=this.FontSizeHalf*3;let unit=calDiv(bw,20);let bx=this.BasePoint[0]+bw*nX;let by=this.BasePoint[1]-bw*nY;if(type.match(/^(warp|return|message|event|disabledSpell|disabledItem)$/)){let x=bx+unit*8;let y=by-unit*16;let str,color;if(type=="warp"){str="W";color="magenta";}else if(type=="return"){str="R";color="magenta";}else if(type=="message"){str="M";color="yellow";}else if(type=="event"){str="E";color="red";}else if(type=="disabledSpell"){str="S";color="white";}else if(type=="disabledItem"){str="I";color="white";}this.drawText(id,x,y,str,color);} else if(type.match(/^(r|rg)[0-9]+$/)){let x=bx+unit*4;let y=by-unit*16;let str=type.replace(/^(rg|r)/,"");str=MF.strFitLength(str,2,"right");let color;if(type.indexOf("rg")>-1){color="red";}else {color="orange";}this.drawText(id,x,y,str,color);} else if(type.match(/^(none|select[CR]|mapping|dark|stone|disabled)$/)){let x=bx+this.LineWidthHalf;let y=by-bw+this.LineWidthHalf;let w=bw-this.LineWidth;if(type.match(/^(dark|disabled|mapping)$/)){this.setGlobalAlpha(id,0.5);}let color;if(type=="dark"){color=this.Color[1];}else if(type=="stone"){color=this.Color[2];}else if(type=="disabled"){color=this.Color[3];}else if(type=="mapping"){color=this.Color[4];}else if(type=="selectC"){color="cyan";}else if(type=="selectR"){color="red";}if(type=="none"){ctx.clearRect(x,y,w,w);}else {this.drawRect(id,x,y,w,w,0,color);}if(type.match(/^(dark|disabled|mapping)$/)){this.setGlobalAlpha(id,1.0);}} else if(type.match(/^(up|down|elevator|turn|pit|seal|chute|shaft|slide[NESWR]|noEntry)$/)){let x=[],y=[];let width=bw-this.LineWidth;x[0]=bx+this.LineWidthHalf;y[0]=by-bw+this.LineWidthHalf;x[1]=x[0]+width;y[1]=y[0]+width;x[2]=x[0]+calTimes(width,0.5);y[2]=y[0]+calTimes(width,0.5);if(type.match(/^(up|down|elevator)$/)){y[3]=y[0]+unit*3;y[4]=y[1]-unit*3;this.drawLine(id,[[x[2],y[3]],[x[2],y[4]]],this.LineWidth,"round","miter","orange");x[3]=x[0]+unit*5;y[5]=y[0]+unit*6;x[4]=x[1]-unit*5;y[6]=y[1]-unit*6;if(type.match(/^(up|elevator)$/)){this.drawLine(id,[[x[3],y[5]],[x[2],y[3]],[x[4],y[5]]],this.LineWidth,"round","miter","orange");}if(type.match(/^(down|elevator)$/)){this.drawLine(id,[[x[3],y[6]],[x[2],y[4]],[x[4],y[6]]],this.LineWidth,"square","","orange");}} else if(type=="turn"){let w=unit*4;this.drawEllipse(id,x[2],y[2],w,w,this.LineWidth,"cyan");w=unit*10;this.drawEllipse(id,x[2],y[2],w,w,this.LineWidth,"cyan");} else if(type=="pit"){y[3]=y[1]-unit*5;let w=unit*12,h=unit*4;this.drawEllipse(id,x[2],y[3],w,h,this.LineWidth,"red");} else if(type=="seal"){x[3]=x[0]+unit*5;x[4]=x[1]-unit*5;y[3]=y[0]+unit*5;y[4]=y[1]-unit*5;this.drawRect(id,x[3],y[3],x[4]-x[3],y[4]-y[3],this.LineWidth,"","yellow");this.drawLine(id,[[x[3],y[3]],[x[4],y[4]]],this.LineWidth,"square","","yellow");this.drawLine(id,[[x[4],y[3]],[x[3],y[4]]],this.LineWidth,"square","","yellow");} else if(type.match(/^(chute|shaft)$/)){let w=unit*12,h=unit*4;y[3]=y[1]-unit*5;y[4]=y[0]+unit*5;x[3]=x[0]+unit*5;x[4]=x[1]-unit*5;if(type=="chute"){this.drawEllipse(id,x[2],y[3],w,h,this.LineWidth,"cyan");this.drawLine(id,[[x[3],y[4]],[x[2],y[3]],[x[4],y[4]]],this.LineWidth,"square","","orange");} else {this.drawEllipse(id,x[2],y[4],w,h,this.LineWidth,"cyan");this.drawLine(id,[[x[3],y[3]],[x[2],y[4]],[x[4],y[3]]],this.LineWidth,"square","","orange");}} else if(type.match(/^slide[NESWR]$/)){x[3]=x[0]+unit*4;x[4]=x[1]-unit*4;y[3]=y[0]+unit*4;y[4]=y[1]-unit*4;if(type=="slideN"){this.drawLine(id,[[x[3],y[4]],[x[2],y[3]],[x[4],y[4]]],this.LineWidth,"square","","magenta");} else if(type=="slideE"){this.drawLine(id,[[x[3],y[3]],[x[4],y[2]],[x[3],y[4]]],this.LineWidth,"square","","magenta");} else if(type=="slideS"){this.drawLine(id,[[x[3],y[3]],[x[2],y[4]],[x[4],y[3]]],this.LineWidth,"square","","magenta");} else if(type=="slideW"){this.drawLine(id,[[x[4],y[3]],[x[3],y[2]],[x[4],y[4]]],this.LineWidth,"square","","magenta");} else if(type=="slideR"){this.drawLine(id,[[x[2],y[3]],[x[2],y[4]]],this.LineWidth,"square","","magenta");this.drawLine(id,[[x[3],y[2]],[x[4],y[2]]],this.LineWidth,"square","","magenta");}} else if(type=="noEntry"){this.setGlobalAlpha(id,0.7);x[3]=x[0]+unit*2;x[4]=x[1]-unit*2;y[3]=y[0]+unit*2;y[4]=y[1]-unit*2;this.drawLine(id,[[x[3],y[3]],[x[4],y[4]]],this.LineWidth,"square","","white");this.drawLine(id,[[x[4],y[3]],[x[3],y[4]]],this.LineWidth,"square","","white");this.setGlobalAlpha(id,1.0);}}}mapWall(id,nX,nY,ws,type){let cv=document.getElementById(id);let ctx=cv.getContext("2d");let bw=this.FontSizeHalf*3;let unit=calDiv(bw,20);if(ws.indexOf("w")>-1){let x=[],y=[];x[0]=this.BasePoint[0]+this.BaseSize*nX;x[1]=x[0]-unit*4;x[2]=x[0]+unit*4;y[0]=this.BasePoint[1]-this.BaseSize*(nY+1)+this.LineWidthHalf;y[1]=this.BasePoint[1]-this.BaseSize*nY-this.LineWidthHalf;y[2]=y[0]+calTimes(y[1]-y[0],0.5);y[3]=y[2]-unit*3;y[4]=y[2]+unit*3;let color="white";if(type.match(/^(wallD|doorD)$/)){color="gray";}else if(type.indexOf("shutter")>-1){color="cyan";}if(!type.match(/^(none|select[CR])$/)){this.drawLine(id,[[x[0],y[0]],[x[0],y[1]]],this.LineWidth,"butt","",color);}if(type=="none"){ctx.clearRect(x[0]-this.LineWidthHalf,y[0],this.LineWidth,y[1]-y[0]);x[3]=x[1]-this.LineWidth-this.LineWidthHalf;y[5]=y[3]-this.LineWidth;let w=x[2]-x[1]+this.LineWidth*3;let h=y[4]-y[3]+this.LineWidth*2;ctx.clearRect(x[3],y[5],w,h);} else if(type.match(/^select[CR]$/)){if(type=="selectC"){color="cyan";}else {color="red";}this.drawRect(id,x[1]-unit*2,y[0],unit*12,y[1]-y[0],0,color);} else if(type.match(/^(door|doorD|lock)$/)){if(type=="doorD"){color="gray";}else if(type=="lock"){color="cyan";}this.drawLine(id,[[x[1],y[3]],[x[2],y[3]]],this.LineWidth,"square","",color);this.drawLine(id,[[x[1],y[4]],[x[2],y[4]]],this.LineWidth,"square","",color);} else if(type.match(/^secret[1-3]$/)){if(type=="secret2"){color="cyan";}else if(type=="secret3"){color="magenta";}let w=unit*7;this.drawEllipse(id,x[0],y[2],w,w,this.LineWidth,color);} else if(type.match(/^oneWay[EW]$/)){if(type.indexOf("E")>-1){this.drawLine(id,[[x[1],y[3]],[x[0],y[3]]],this.LineWidth,"square","",color);this.drawLine(id,[[x[1],y[4]],[x[0],y[4]]],this.LineWidth,"square","",color);} else {this.drawLine(id,[[x[0],y[3]],[x[2],y[3]]],this.LineWidth,"square","",color);this.drawLine(id,[[x[0],y[4]],[x[2],y[4]]],this.LineWidth,"square","",color);}} else if(type.match(/^shutter[EW]$/)){color="white";if(type.indexOf("E")>-1){this.drawLine(id,[[x[1],y[3]],[x[2],y[2]],[x[1],y[4]]],this.LineWidth,"square","",color);} else {this.drawLine(id,[[x[2],y[3]],[x[1],y[2]],[x[2],y[4]]],this.LineWidth,"square","",color);}}} else if(ws.indexOf("s")>-1){let x=[],y=[];x[0]=this.BasePoint[0]+this.BaseSize*nX+this.LineWidthHalf;x[1]=this.BasePoint[0]+this.BaseSize*(nX+1)-this.LineWidthHalf;x[2]=x[0]+calTimes(x[1]-x[0],0.5);x[3]=x[2]-unit*3;x[4]=x[2]+unit*3;y[0]=this.BasePoint[1]-this.BaseSize*nY;y[1]=y[0]-unit*4;y[2]=y[0]+unit*4;let color="white";if(type.match(/^(wallD|doorD)$/)){color="gray";}else if(type.indexOf("shutter")>-1){color="cyan";}if(!type.match(/^(none|select[CR])$/)){this.drawLine(id,[[x[0],y[0]],[x[1],y[0]]],this.LineWidth,"butt","",color);}if(type=="none"){ctx.clearRect(x[0],y[0]-this.LineWidthHalf,x[1]-x[0],this.LineWidth);x[5]=x[3]-this.LineWidth;y[3]=y[1]-this.LineWidth-this.LineWidthHalf;let w=x[4]-x[3]+this.LineWidth*2;let h=y[2]-y[1]+this.LineWidth*3;ctx.clearRect(x[5],y[3],w,h);} else if(type.match(/^select[CR]$/)){if(type=="selectC"){color="cyan";}else {color="red";}this.drawRect(id,x[0],y[1]-unit*2,x[1]-x[0],unit*12,0,color);} else if(type.match(/^(door|doorD|lock)$/)){if(type=="doorD"){color="gray";}else if(type=="lock"){color="cyan";}this.drawLine(id,[[x[3],y[1]],[x[3],y[2]]],this.LineWidth,"square","",color);this.drawLine(id,[[x[4],y[1]],[x[4],y[2]]],this.LineWidth,"square","",color);} else if(type.match(/^secret[1-3]$/)){if(type=="secret2"){color="cyan";}else if(type=="secret3"){color="magenta";}let w=unit*7;this.drawEllipse(id,x[2],y[0],w,w,this.LineWidth,color);} else if(type.match(/^oneWay[NS]$/)){if(type.indexOf("S")>-1){this.drawLine(id,[[x[3],y[1]],[x[3],y[0]]],this.LineWidth,"square","",color);this.drawLine(id,[[x[4],y[1]],[x[4],y[0]]],this.LineWidth,"square","",color);} else {this.drawLine(id,[[x[3],y[0]],[x[3],y[2]]],this.LineWidth,"square","",color);this.drawLine(id,[[x[4],y[0]],[x[4],y[2]]],this.LineWidth,"square","",color);}} else if(type.match(/^shutter[NS]$/)){color="white";if(type.indexOf("S")>-1){this.drawLine(id,[[x[3],y[1]],[x[2],y[2]],[x[4],y[1]]],this.LineWidth,"square","",color);} else {this.drawLine(id,[[x[3],y[2]],[x[2],y[1]],[x[4],y[2]]],this.LineWidth,"square","",color);}}}}setGlobalAlpha(id,alpha){let cv=document.getElementById(id);let ctx=cv.getContext("2d");ctx.globalAlpha=alpha;}viewMap(mode){mode=checkNull(mode,0);for(let i=0;i<5;i++){this.clearCanvas("cv"+String(i));}this.mapBase("cv0",this.MapWidth,this.MapHeight);if(mode==1){this.viewMonsterRoom();} else {for(let x=0;x<this.MapWidth;x++){for(let y=0;y<this.MapHeight;y++){this.viewMapSpace(x,y);}}}for(let x=0;x<this.MapWidth;x++){for(let y=0;y<this.MapHeight;y++){this.viewMapWall(x,y,"w");}}for(let x=0;x<this.MapWidth;x++){for(let y=0;y<this.MapHeight;y++){this.viewMapWall(x,y,"s");}}if(mode==2){for(let x=0;x<this.MapWidth;x++){for(let y=0;y<this.MapHeight;y++){if(!this.Mapping[x][y]){this.mapSpace("cv3",x,y,"mapping");}}}}}viewMapSpace(x,y){this.mapSpace("cv1",x,y,"none");let strAry;let flagDisabled=false;let type="none";let space=this.Space[x][y];if(space.charAt(0)=="0"){ return;}else if(space.charAt(0)=="1"){type="dark";}else if(space.charAt(0)=="2"){type="up";}else if(space.charAt(0)=="3"){type="elevator";}else if(space.charAt(0)=="4"){type="down";}else if(space.charAt(0)=="5"){type="turn";}else if(space.charAt(0)=="6"){type="pit";}else if(space.charAt(0)=="7"){type="message";}else if(space.charAt(0)=="8"){type="chute";}else if(space.charAt(0)=="9"){type="shaft";}else if(space.charAt(0)=="a"){type="stone";}else if(space.charAt(0)=="b"){type="noEntry";}else if(space.charAt(0)=="E"){type="event";}else if(space.charAt(0)=="R"){type="return";}else if(space.charAt(0)=="S"){type="seal";}else if(space.charAt(0)=="W"){type="warp";}else if(space.charAt(0)=="c"){flagDisabled=true;strAry=space.split(",");if(strAry[1]=="0"){type="disabledSpell";}else if(strAry[1]=="1"){type="disabledItem";}} else if(space.charAt(0)=="d"){strAry=space.split(",");let num=Number(strAry[1]);if(num==0){type="slideN";}else if(num==1){type="slideE";}else if(num==2){type="slideS";}else if(num==3){type="slideW";}else {type="slideR";}}this.mapSpace("cv1",x,y,type);strAry=space.split("<>");let strAry2=strAry[0].split(",");strAry2.shift();if(strAry2.indexOf("b")>-1){this.mapSpace("cv1",x,y,"noEntry");}if(strAry2.indexOf("c0")>-1||strAry2.indexOf("c1")>-1||strAry2.indexOf("c2")>-1){flagDisabled=true;}if(flagDisabled){this.mapSpace("cv1",x,y,"disabled");}}viewMapWall(x,y,ws){this.mapWall("cv2",x,y,ws,"none");let overX=-1,overY=-1;if((ws=="w"&&x==0)||(ws=="s"&&y==0)){overX=x,overY=y;if(ws=="w"){overX=this.MapWidth;}else {overY=this.MapHeight;}this.mapWall("cv2",overX,overY,ws,"none");}let wall,type="none";if(ws=="w"){wall=this.WestWall[x][y];}else {wall=this.SouthWall[x][y];}let strAry=wall.split(",");let num;if(wall.charAt(0)=="6"){type="lock";}else if(wall.charAt(0)=="1"){type="wall";if(strAry.length>1){num=toNumber(strAry[1]);}else {num=0;}if(!this.WallFlag[num]){type="wallD";}} else if(wall.charAt(0)=="2"){type="door";if(strAry.length>1){num=toNumber(strAry[1]);}else {num=0;}if(!this.WallFlag[num]){type="doorD";}} else if(wall.charAt(0)=="3"){type="secret1";if(strAry.length>3){if(strAry[3].match(/^ws|en$/)){type="secret3";}else {type="secret2";}}} else if(wall.charAt(0)=="4"){num=toNumber(strAry[1]);if(num==0){type="oneWayN";}else if(num==1){type="oneWayE";}else if(num==2){type="oneWayS";}else if(num==3){type="oneWayW";}} else if(wall.charAt(0)=="5"){num=toNumber(strAry[1]);if(num==0){type="shutterN";}else if(num==1){type="shutterE";}else if(num==2){type="shutterS";}else if(num==3){type="shutterW";}}if(type!="none"){this.mapWall("cv2",x,y,ws,type);}if(overX>-1){this.mapWall("cv2",overX,overY,ws,type);}}viewMonsterRoom(){this.clearCanvas("cv1");for(let x=0;x<this.MapWidth;x++){for(let y=0;y<this.MapHeight;y++){if(this.MonsterRoom[x][y]>-1){let num=this.MonsterRoom[x][y];if(this.RoomGuardian[num]==""){this.mapSpace("cv1",x,y,"r"+String(num));}else {this.mapSpace("cv1",x,y,"rg"+String(num));}}}}}viewMonsterRoomNum(){let set= new Set();for(let x=0;x<MP.MapWidth;x++){for(let y=0;y<MP.MapHeight;y++){if(MP.MonsterRoom[x][y]>-1){set.add(MP.MonsterRoom[x][y]);}}}let dataAry=Array.from(set);dataAry.sort(function(a,b){ return a-b;});let result="";for(let i=0;i<dataAry.length;i++){if(result!=""){result+=", ";}result+=String(dataAry[i]);}setData("MonsterRoomNum",result);}}