/*
 * Decompiled with CFR 0.152.
 */
package classFile;

import classFile.GameMode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DebugFrame
extends JFrame
implements WindowListener,
ComponentListener {
    private GameMode Gm;
    private JScrollPane ScrollPane;
    private JTextArea TextArea;
    private ArrayList<String> Stack = new ArrayList();
    private Font FontData;
    private int FontWidth;
    private int LineHeight;
    private int MarginX;
    private int MarginY;
    private int FontSize;
    private int WindowWidth;
    private int WindowHeight;
    private final int MAX_LINE = 1000;

    DebugFrame(GameMode gameMode, int n, int n2, int n3) {
        this.Gm = gameMode;
        this.FontSize = n3;
        ImageIcon imageIcon = new ImageIcon(this.Gm.DIR_PATH + "graphic/icon.gif");
        this.setIconImage(imageIcon.getImage());
        this.setTitle("Debug Window");
        this.TextArea = new JTextArea();
        this.setFont();
        this.TextArea.setFont(this.FontData);
        this.getFontWidth();
        this.WindowWidth = n;
        this.WindowHeight = n2;
        this.setWindowSize();
        this.TextArea.setLineWrap(true);
        this.TextArea.setBackground(Color.BLACK);
        this.TextArea.setForeground(Color.WHITE);
        this.TextArea.setCaretColor(Color.WHITE);
        this.TextArea.setEditable(false);
        this.TextArea.setMargin(new Insets(0, this.FontWidth, 0, this.FontWidth));
        this.ScrollPane = new JScrollPane(this.TextArea);
        JPanel jPanel = new JPanel();
        jPanel.add(this.ScrollPane);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        this.addWindowListener(this);
        this.addComponentListener(this);
    }

    public void addStack(String string) {
        if (!string.equals("")) {
            this.Stack.add(string);
            if (this.Stack.size() > 1000) {
                this.Stack.remove(0);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.Stack.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.Stack.get(i) + "\n");
        }
        this.setText(stringBuffer.toString());
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.setColumnsAndRows();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    private void getFontWidth() {
        FontMetrics fontMetrics = this.TextArea.getFontMetrics(this.FontData);
        this.FontWidth = fontMetrics.charWidth('a');
        this.LineHeight = fontMetrics.getHeight();
    }

    public void getMargin() {
        Insets insets = this.getInsets();
        this.MarginX = insets.left + insets.right;
        this.MarginY = insets.top + insets.bottom;
    }

    public void setColumnsAndRows() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n - (this.MarginX + this.FontWidth * 2 + 20);
        int n4 = n2 - (this.MarginY + 12);
        this.TextArea.setColumns(n3 / this.FontWidth);
        this.TextArea.setRows(n4 / this.LineHeight);
        this.revalidate();
        this.repaint();
    }

    private void setFont() {
        if (this.Gm.FONT_NAME.indexOf(".ttf") > -1 || this.Gm.FONT_NAME.indexOf(".TTF") > -1) {
            try {
                this.FontData = Font.createFont(0, new File(this.Gm.ConfigDir + this.Gm.FONT_NAME)).deriveFont(0, this.FontSize);
            }
            catch (Exception exception) {
                this.FontData = new Font(this.Gm.FONT_NAME, 0, this.FontSize);
            }
        } else {
            this.FontData = new Font(this.Gm.FONT_NAME, 0, this.FontSize);
        }
    }

    public void setText(String string) {
        this.TextArea.setText(string);
        this.TextArea.setCaretPosition(string.length());
        JScrollBar jScrollBar = this.ScrollPane.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getMaximum());
    }

    public void setWindowSize() {
        this.setSize(this.WindowWidth, this.WindowHeight);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.Gm.FRAME.MenuDebugWindow.setSelected(false);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

